/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import java.util.*;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Expression;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.StatementBlock;
import org.netbeans.jmi.javamodel.SynchronizedStatement;
import org.netbeans.lib.java.parser.ASTree;
import org.netbeans.mdr.storagemodel.StorableObject;
import org.netbeans.modules.javacore.parser.ASTProvider;

/**
 *
 * @author  Martin Matula
 */
public abstract class SynchronizedStatementImpl extends StatementImpl implements SynchronizedStatement {
    private Expression expression = null;
    private StatementBlock body = null;
    
    /** Creates a new instance of SynchronizedStatementImpl */
    public SynchronizedStatementImpl(StorableObject o) {
        super(o);
    }
    
    public void setLock(Expression expression) {
        objectChanged(CHANGED_LOCK);
        changeChild(getLock(), expression);
        this.expression = expression;
    }
    
    public Expression getLock() {
        if (!childrenInited) {
            initChildren();
        }
        return expression;
    }
    
    public void setBody(StatementBlock body) {
        objectChanged(CHANGED_BODY);
        changeChild(getBody(), body);
        this.body = body;
    }
    
    public StatementBlock getBody() {
        if (!childrenInited) {
            initChildren();
        }
        return body;
    }
    
    public List getChildren() {
        List list = new ArrayList(2);
        addIfNotNull(list, getLock()); 
        addIfNotNull(list, getBody()); 
        return list;
    }
    
    protected void initChildren() {
        childrenInited = false;
        ASTree tree = getASTree();
        if (tree != null) {
            expression = (Expression) initOrCreate(expression, tree.getSubTrees()[0]);
            body = (StatementBlock) initOrCreate(body, tree.getSubTrees()[1]);
        }
        childrenInited = true;
    }
    
    public String getSourceText() {
        String origElem;
        if ((origElem = checkChange()) != null)
            return origElem;
        StringBuffer buf = new StringBuffer();
        StatementImpl body = (StatementImpl) getBody();
        StatementImpl lock = (StatementImpl) getLock();
        buf.append('\n');
        formatElementPart(SYNCHRONIZED_KEYWORD, buf);
        formatElementPart(STMT_OPEN_BRACKET, buf);
        buf.append(lock.getSourceText());
        formatElementPart(STMT_CLOSE_BRACKET, buf);
        buf.append(body.getSourceText());
        return buf.toString();
    }

    public void getDiff(List diff) {
        ASTProvider parser = getParser();
        ASTree tree = getASTree();
        ASTree[] children = tree.getSubTrees();

        getChildDiff(diff, parser, children[0], (MetadataElement) getLock(), CHANGED_LOCK);
        getChildDiff(diff, parser, children[1], (MetadataElement) getBody(), CHANGED_BODY);
    }
    
    void setData(Expression expression, StatementBlock body) {
        changeChild(null, expression);
        this.expression = expression;
        changeChild(null, body);
        this.body = body;
    }

    protected void _delete() {
        // --- delete components -------------------------------------------
        if (childrenInited) {
            deleteChild(expression);
            deleteChild(body);
        }
        // --- delete links -----------------------------------------------
        // no links to delete
        // --- call super ---------------------------------------
        super._delete();
    }
    
    public void replaceChild(Element oldElement,Element newElement) {
        if (childrenInited) {
            if (oldElement.equals(expression)) {
                setLock((Expression)newElement);
            } else if (oldElement.equals(body)) {
                setBody((StatementBlock)newElement);
            }
        }
    }
    
    public Element duplicate(JavaModelPackage targetExtent) {
        return targetExtent.getSynchronizedStatement().createSynchronizedStatement(
                (Expression) duplicateElement(getLock(), targetExtent), 
                (StatementBlock) duplicateElement(getBody(), targetExtent));
    }
}
