/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.javacore.jmiimpl.javamodel;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.jmi.reflect.*;
import javax.jmi.model.GeneralizableElement;
import javax.jmi.model.Attribute;
import org.netbeans.jmi.javamodel.*;

/** Used by ArrayLengthField to represent type.
 * [TODO] check whether this class is really necessary (ArrayLengthField most likely does not need to support returning multipartid for type
 *
 * @author  Daniel Prusa
 */
public class SyntheticMultipartId implements MultipartId {
    public static final String MOF_ID_PREFIX = "SyntheticMultipartId:"; // NOI18N
    
    private TypedElement parent;
    private String mofId;
    
    SyntheticMultipartId(TypedElement parent) {
        this.parent = parent;
        mofId = MOF_ID_PREFIX + parent.refMofId();
    }
    
    public NamedElement getElement() {
        return (NamedElement) parent;
    }    
    
    public int getEndOffset() {
        return 0;
    }
    
    public String getName() {
        return parent.getType().getName();
    }
    
    public MultipartId getParent() {
        return null;
    }
    
    public int getPartEndOffset(ElementPartKind part) {
        return 0;
    }
    
    public int getPartStartOffset(ElementPartKind part) {
        return 0;
    }
    
    public Resource getResource() {
        return parent.getResource();
    }
    
    public int getStartOffset() {
        return 0;
    }
    
    public Type getType() {
        return parent.getType();
    }
    
    public Collection getReferences() {
        return Collections.EMPTY_LIST;
    }

    public List getChildren() {
        return Collections.EMPTY_LIST;
    }

    public boolean isValid() {
        return true;
    }

    public RefClass refClass() {
        return ((JavaModelPackage) refImmediatePackage()).getMultipartId();
    }
    
    public void refDelete() {
        // do nothing
    }
    
    public Object refGetValue(RefObject refObject) {
        if (!(refObject instanceof Attribute)) {
            throw new InvalidCallException(null, refObject);
        }
        return refGetValue(((Attribute) refObject).getName());
    }
    
    public Object refGetValue(String str) {
         if ("element".equals(str)) { // NOI18N
            return getElement();
        } else if ("name".equals(str)) { // NOI18N
            return getName();
        } else if ("type".equals(str)) { // NOI18N
            return getType();
        } else if ("parent".equals(str)) { // NOI18N
            return getParent();
        }
        throw new InvalidCallException(null, null, "Invalid attribute name: " + str); // NOI18N
    }
    
    public RefFeatured refImmediateComposite() {
        return parent;
    }
    
    public RefPackage refImmediatePackage() {
        return parent.refImmediatePackage();
    }
    
    public Object refInvokeOperation(RefObject refObject, List list) throws RefException {
        throw new InvalidCallException(null, null);
    }
    
    public Object refInvokeOperation(String str, List list) throws RefException {
        throw new InvalidCallException(null, null);
    }
    
    public boolean refIsInstanceOf(RefObject objType, boolean considerSubtypes) {
        GeneralizableElement metaObject = (GeneralizableElement) refMetaObject();
        return isInstanceOf(metaObject, objType, considerSubtypes);
    }
    
    private boolean isInstanceOf(GeneralizableElement metaObject, RefObject objType, boolean considerSubtypes) {
        if (metaObject.equals(objType))
            return true;
        if (considerSubtypes) {
            Iterator it = metaObject.getSupertypes().iterator();
            while (it.hasNext()) {
                if (isInstanceOf(((GeneralizableElement) it.next()), objType, true)) {
                    return true;
                }
            }
        }
        return false;
    }
    
    public RefObject refMetaObject() {
        return refClass().refMetaObject();
    }
    
    public String refMofId() {
        return mofId;
    }
    
    public RefFeatured refOutermostComposite() {
        return parent.refOutermostComposite();
    }
    
    public RefPackage refOutermostPackage() {
        return parent.refOutermostPackage();
    }
    
    public void refSetValue(String str, Object obj) {
        ArrayImpl.throwIsReadOnly(this);
    }
    
    public void refSetValue(RefObject refObject, Object obj) {
        ArrayImpl.throwIsReadOnly(this);
    }
    
    public Collection refVerifyConstraints(boolean param) {
        return Collections.EMPTY_LIST;
    }
    
    public void replaceChild(Element oldChild, Element newChild) {
        ArrayImpl.throwIsReadOnly(this);
    }
    
    public void setElement(NamedElement newValue) {
        ArrayImpl.throwIsReadOnly(this, "element"); // NOI18N
    }
    
    public void setName(String newValue) {
        ArrayImpl.throwIsReadOnly(this, "name"); // NOI18N
    }
    
    public void setParent(MultipartId newValue) {
        ArrayImpl.throwIsReadOnly(this, "parent"); // NOI18N
    }
    
    public void setType(Type newValue) {
        ArrayImpl.throwIsReadOnly(this, "type"); // NOI18N
    }
    
    public List getTypeArguments() {
        return Collections.EMPTY_LIST;
    }
    
    public Element duplicate() {
        throw new UnsupportedOperationException();
    }
}
