/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.TagDefinition;
import org.netbeans.jmi.javamodel.TagValue;
import org.netbeans.mdr.storagemodel.StorableObject;
import org.netbeans.modules.javacore.parser.MDRParser;

/**
 * Implementation of TagValue object instance interface.
 *
 * @author Vladimir Hudec
 */
public abstract class TagValueImpl extends MetadataElement implements TagValue {
    
    protected String value = null;
    protected TagDefinition tagDefinition = null;
    
    private boolean isNew = false;
    protected boolean childrenInited = false;
    
    
    protected TagValueImpl(StorableObject s) {
        super(s);
    }
    
    protected final boolean isInitialized() {
        return isNew;
    }
    
    /** Overriding methods must call super.setNew() */
    protected void setNew() {
        setChanged();
        isNew = true;
        childrenInited = true;
    }
    
    protected final boolean isNew() {
        return isNew;
    }
 
    /**
     * Returns the value of attribute value.
     * @return Value of attribute value.
     */
    public String getValue() {
        return value;
    }
    
    /**
     * Sets the value of value attribute. See {@link #getValue} for description 
     * on the attribute.
     * @param newValue New value to be set.
     */
    public void setValue(String newValue) {
        objectChanged(CHANGED_JAVADOC);
        this.value = newValue;
    }
    
    /**
     * Returns the value of reference definition.
     * @return Value of reference definition.
     */
    public TagDefinition getDefinition() {
        return tagDefinition;
    }
    
    /**
     * Sets the value of reference definition. See {@link #getDefinition} for 
     * description on the reference.
     * @param newValue New value to be set.
     */
    public void setDefinition(TagDefinition newValue) {
        if (tagDefinition != null && newValue != null && tagDefinition.equals(newValue))
            return;

        IsValueForImpl isValueForImpl = (IsValueForImpl)(((JavaModelPackage) refImmediatePackage()).getIsValueFor());

        if (tagDefinition != null)
            isValueForImpl.remove(this, tagDefinition);
        if (newValue != null)
            isValueForImpl.add(this, newValue);
    }
    
    void setData(String name, String value) {
        if (name != null) {
            JavaModelPackage pkg = (JavaModelPackage) refImmediatePackage();
            TagDefinitionClassImpl tagDefinitionClass = (TagDefinitionClassImpl) pkg.getTagDefinition();
            setData(value, tagDefinitionClass.createTagDefinition(name));
        }
        else {
            setData(value, (TagDefinition)null);
        }
    }

    void setData(String value, TagDefinition tagDefinition) {
        this.value = value;
        this.tagDefinition = tagDefinition;
    }
    
    protected java.lang.Object getInternalForm() {
        return value;
    }
    
    public MDRParser getParser() {
        return null;
    }
    
    public Element duplicate(JavaModelPackage targetExtent) {
        TagValueClassImpl tagProxy = (TagValueClassImpl)targetExtent.getTagValue();
        String name = null;
        TagDefinition def = getDefinition();
        
        if (def != null)
            name = def.getName();
        return tagProxy.create(name,getValue());
    }
}
