/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import java.util.*;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.StatementBlock;
import org.netbeans.jmi.javamodel.TryStatement;
import org.netbeans.lib.java.parser.ASTree;
import org.netbeans.lib.java.parser.ASTreeTypes;
import org.netbeans.mdr.storagemodel.StorableObject;
import org.netbeans.modules.javacore.parser.ASTProvider;

/**
 *
 * @author  Martin Matula
 */
public abstract class TryStatementImpl extends StatementImpl implements TryStatement {
    private StatementBlock body = null;
    private LightAttrList catches = null;
    private StatementBlock finalizer = null;
    
    /** Creates a new instance of TryStatementImpl */
    public TryStatementImpl(StorableObject o) {
        super(o);
    }
    
    public void setBody(StatementBlock body) {
        objectChanged(CHANGED_BODY);
        changeChild(getBody(), body);
        this.body = body;
    }
    
    public StatementBlock getBody() {
        if (!childrenInited) {
            initChildren();
        }
        return body;
    }
    
    public void setFinalizer(StatementBlock finalizer) {
        objectChanged(CHANGED_FINALIZER);
        changeChild(getFinalizer(), finalizer);
        this.finalizer = finalizer;
    }
    
    public StatementBlock getFinalizer() {
        if (!childrenInited) {
            initChildren();
        }
        return finalizer;
    }
    
    public List getCatches() {
        if (!childrenInited) {
            initChildren();
        }
        return catches;
    }
    
    public List getChildren() {
        List list = new ArrayList(2 + getCatches().size());
        addIfNotNull(list, getBody()); 
        list.addAll(getCatches()); 
        addIfNotNull(list, getFinalizer()); 
        return list;
    }
    
    protected void initChildren() {
        childrenInited = false;
        ASTree tree = getASTree();
        if (tree != null) {
            ASTree[] parts = tree.getSubTrees();
            body = (StatementBlock) initOrCreate(body, parts[0]);
            catches = createChildrenList(catches, "catches", parts[1], ASTreeTypes.CATCHES, CHANGED_CATCHES, false); // NOI18N
            finalizer = (StatementBlock) initOrCreate(finalizer, parts[2]);
        }
        childrenInited = true;
    }
    
    String getRawText() {
        StringBuffer buf = new StringBuffer();
        StatementImpl body = (StatementImpl) getBody();
        List catches = getCatches();
        TransientElement finalizer = (TransientElement)getFinalizer();
        formatElementPart(TRY_KEYWORD, buf);
        buf.append(body.getSourceText());
        for (Iterator iter = catches.iterator(); iter.hasNext();) {
            TransientElement cas = (TransientElement) iter.next();
            buf.append(cas.getSourceText());
        }
        if (finalizer != null) {
            formatElementPart(FINALLY_KEYWORD, buf);
            buf.append(finalizer.getSourceText());
        }
        return buf.toString();
    }

    public void getDiff(List diff) {
        ASTProvider parser = getParser();
        ASTree tree = getASTree();
        ASTree[] children = tree.getSubTrees();

        getChildDiff(diff, parser, children[0], (MetadataElement) getBody(), CHANGED_BODY);
        int pos;
        if (children[2] == null) {
            pos = parser.getToken(tree.getLastToken()).getEndOffset();
        } else {
            pos = parser.getToken(children[2].getFirstToken()).getStartOffset();
        }
        getCollectionDiff(diff, parser, CHANGED_CATCHES, children[1], ASTreeTypes.CATCHES, getCatches(), pos, "\n"); // NOI18N
        getChildDiff(diff, parser, children[2], (MetadataElement) getFinalizer(), CHANGED_FINALIZER, pos, "\n"); // NOI18N
    }
    
    void setData(StatementBlock body, List catches, StatementBlock finalizer) {
        changeChild(null, body);
        this.body = body;
        this.catches = createChildrenList("catches", catches, CHANGED_CATCHES); // NOI18N
        changeChild(null, finalizer);
        this.finalizer = finalizer;
    }

    protected void _delete() {
        // --- delete components -------------------------------------------
        if (childrenInited) {
            deleteChild(body);
            deleteChild(finalizer);
            deleteChildren(catches);
        }
        // --- delete links -----------------------------------------------
        // no links to delete
        // --- call super ---------------------------------------
        super._delete();
    }
    
    public void replaceChild(Element oldElement,Element newElement) {
        if (childrenInited) {
            if (oldElement.equals(body)) {
                setBody((StatementBlock)newElement);
            } else if (oldElement.equals(finalizer)) {
                setFinalizer((StatementBlock)newElement);
            } else
                replaceObject(getCatches(),oldElement,newElement);
        }
    }
    
    public Element duplicate(JavaModelPackage targetExtent) {
        return targetExtent.getTryStatement().createTryStatement(
                (StatementBlock) duplicateElement(getBody(), targetExtent),
                duplicateList(getCatches(), targetExtent),
                (StatementBlock) duplicateElement(getFinalizer(), targetExtent)
               );
    }
}
