/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import org.netbeans.jmi.javamodel.*;
import org.netbeans.lib.java.parser.ASTree;
import org.netbeans.mdr.storagemodel.StorableObject;
import org.netbeans.modules.javacore.parser.ASTProvider;
import java.util.*;

/**
 *
 * @author  Martin Matula
 */
public abstract class TypeCastImpl extends ExpressionImpl implements TypeCast {
    private Expression expression;
    private TypeReference typeName;

    /** Creates a new instance of TypeCastImpl */
    public TypeCastImpl(StorableObject o) {
        super(o);
    }
    
    public Expression getExpression() {
        if (!childrenInited) {
            initChildren();
        }
        return expression;
    }
    
    public void setExpression(Expression expression) {
        objectChanged(CHANGED_EXPRESSION);
        changeChild(getExpression(), expression);
        this.expression = expression;
    }

    public TypeReference getTypeName() {
        if (!childrenInited) {
            initChildren();
        }
        return typeName;
    }

    public void setTypeName(TypeReference typeName) {
        objectChanged(CHANGED_TYPE);
        changeChild(getTypeName(), typeName);
        this.typeName = typeName;
    }

    public Type getType() {
        return (Type) getTypeName().getElement();
    }

    public void setType(Type newValue) {
        MultipartIdClass proxy = ((JavaModelPackage) refImmediatePackage()).getMultipartId();
        setTypeName(proxy.createMultipartId(newValue.getName(), null, null));
    }

    public List getChildren() {
        List list = new ArrayList(2);
        addIfNotNull(list, getTypeName());
        addIfNotNull(list, getExpression());
        return list;
    }
    
    protected void initChildren() {
        childrenInited = false;
        ASTree tree = getASTree();
        if (tree != null) {
            ASTree[] parts = tree.getSubTrees();
            typeName = (TypeReference) initOrCreate(typeName, parts[0]);
            expression = (Expression) initOrCreate(expression, parts[1]);
        }
        childrenInited = true;
    }
    
    public String getSourceText() {
        String origElem;
        if ((origElem = checkChange()) != null)
            return origElem;
        StringBuffer buf = new StringBuffer();
        StatementImpl expr = (StatementImpl) getExpression();
        formatElementPart(STMT_OPEN_BRACKET, buf);
        buf.append(((MetadataElement) getTypeName()).getSourceText());
        formatElementPart(STMT_CLOSE_BRACKET, buf);
        buf.append(' ');
        buf.append(expr.getSourceText());
        return buf.toString();
    }

    public void getDiff(List diff) {
        ASTProvider parser = getParser();
        ASTree tree = getASTree();
        ASTree[] children = tree.getSubTrees();

        getChildDiff(diff, parser, children[0], (MetadataElement) getTypeName(), CHANGED_TYPE);
        getChildDiff(diff, parser, children[1], (MetadataElement) getExpression(), CHANGED_EXPRESSION);
    }

    void setData(Expression expression, TypeReference typeName) {
        changeChild(null, expression);
        this.expression = expression;
        changeChild(null, typeName);
        this.typeName = typeName;
    }

    protected void _delete() {
        // --- delete components -------------------------------------------
        if (childrenInited) {
            deleteChild(expression);
            deleteChild(typeName);
        }
        // --- delete links -----------------------------------------------
        // no links to delete
        // --- call super ---------------------------------------
        super._delete();
    }
    
    public void replaceChild(Element oldElement,Element newElement) {
        if (childrenInited) {
            if (oldElement.equals(expression)) {
                setExpression((Expression)newElement);
            }
            if (oldElement.equals(typeName)) {
                setTypeName((TypeReference)newElement);
            }
        }
    }
    
    public Element duplicate(JavaModelPackage targetExtent) {
        return targetExtent.getTypeCast().createTypeCast(
                (TypeReference) duplicateElement(getTypeName(), targetExtent),
                (Expression) duplicateElement(getExpression(), targetExtent)
               );
    }
}
