/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.javacore.jmiimpl.javamodel;

import java.util.ArrayList;
import java.util.AbstractList;
import java.util.List;
import org.netbeans.api.mdr.events.AttributeEvent;
import org.netbeans.jmi.javamodel.TypeClass;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.modules.javacore.parser.TypeRef;

/**
 * @author Martin Matula
 */
public class TypeList extends AbstractList {
    protected final List innerList;
    protected final SemiPersistentElement parent;

    public TypeList(SemiPersistentElement parent) {
        this(parent, new ArrayList());
    }
    
    public TypeList(SemiPersistentElement parent, ArrayList innerList) {
        this.parent = parent;
        this.innerList = innerList;
    }

    public Object get(int index) {
        return wrap(innerList.get(index));
    }

    public Object remove(int index) {
        try {
            fireChange(AttributeEvent.EVENT_ATTRIBUTE_REMOVE, null, index);
            return wrap(innerList.remove(index));
        } finally {
            updateParent();
        }
    }

    public void add(int index, Object element) {
        try {
            TypeRef tr = unwrap(element);
            fireChange(AttributeEvent.EVENT_ATTRIBUTE_ADD, tr, index);
            innerList.add(index, tr);
        } finally {
            updateParent();
        }
    }

    public Object set(int index, Object element) {
        try {
            TypeRef tr = unwrap(element);
            fireChange(AttributeEvent.EVENT_ATTRIBUTE_SET, tr, index);
            return wrap(innerList.set(index, tr));
        } finally {
            updateParent();
        }
    }
    
    public int size() {
        return innerList.size();
    }

    private TypeRef unwrap(Object element) {
        return SemiPersistentElement.typeToTypeRef((Type) element);
    }

    private Object wrap(Object o) {
        return parent.resolveType((TypeRef) o);
    }

    void addTypeRef(TypeRef typeRef) {
        innerList.add(typeRef);
    }
    
    protected void fireChange(int attrType, TypeRef newValue, int position) {
    }
    
    protected void updateParent() {
    }
}
