/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.javacore.jmiimpl.javamodel;

import java.util.Collection;
import java.util.Collections;
import javax.jmi.reflect.ConstraintViolationException;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.jmi.javamodel.UnresolvedAnnotationType;
import org.netbeans.jmi.javamodel.UnresolvedAnnotationTypeClass;
import org.netbeans.mdr.util.DebugException;
import org.netbeans.mdr.handlers.ClassProxyHandler;
import org.netbeans.mdr.persistence.MOFID;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.storagemodel.StorableBaseObject;
import org.netbeans.mdr.storagemodel.StorableClass;
import org.netbeans.modules.javacore.JMManager;
import org.openide.ErrorManager;

/**
 *
 * @author Martin Matula
 */
public abstract class UnresolvedAnnotationTypeClassImpl  extends ClassProxyHandler implements UnresolvedAnnotationTypeClass {
    // [TODO] add support for refAllOfClass/Type
    
    private static final String MOFID_PREFIX = "unresolvedAnn:"; // NOI18N
    private static final InstanceMap allInstances = new InstanceMap();
    
    public UnresolvedAnnotationTypeClassImpl(StorableClass s) {
        super(s);
    }
    
    public UnresolvedAnnotationType createUnresolvedClass(String name, java.util.List annotations, int modifiers, String javadocText, org.netbeans.jmi.javamodel.JavaDoc javadoc, java.util.List contents, org.netbeans.jmi.javamodel.MultipartId superClassName, java.util.List interfaceNames, java.util.List typeArguments) {
        throw new ConstraintViolationException(this, refMetaObject(), "Cannot create unresolved AnnotationType explicitly."); // NOI18N
    }
    
    public UnresolvedAnnotationType createUnresolvedClass() {
        throw new ConstraintViolationException(this, refMetaObject(), "Cannot create unresolved AnnotationType explicitly."); // NOI18N
    }
    
    public UnresolvedAnnotationType resolveUnresolved(String name) {
        if (name == null) {
            JMManager.getLog().notify(ErrorManager.INFORMATIONAL, new Exception("!! Trying to get unresolved AnnotationType for name == null")); // NOI18N
            return null;
        }
        UnresolvedAnnotationTypeImpl result = (UnresolvedAnnotationTypeImpl) allInstances.get(name);
        if (result == null) {
            try {
                // [TODO] better unify immediate package and class proxy
                StorableBaseObject s = _getDelegate();
                MOFID mofId = new MOFID(name.hashCode(), MOFID_PREFIX + name);
                DeferredObject o = new DeferredObject(mofId, s.getMdrStorage(), s.getImmediatePackageId(), s.getOutermostPackageId(), s.getMetaObject(), (StorableClass) s, null);
                result = (UnresolvedAnnotationTypeImpl) _getRepository().getHandler(o);
                result.name = name;
                allInstances.put(name, result);
            } catch (StorageException e) {
                throw new DebugException();
            }
        }
        return result;
    }
    
    protected Collection _allOfClass(boolean recursive) {
        return Collections.unmodifiableCollection(allInstances.values());
    }
    
    public Type resolve(String name) {
        JavaModelPackage pkg = (JavaModelPackage) refImmediatePackage();
        return pkg.getType().resolve(name);
    }
}
