/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import java.util.ArrayList;
import org.netbeans.jmi.javamodel.Assignment;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Operator;
import org.netbeans.jmi.javamodel.OperatorEnum;
import org.netbeans.jmi.javamodel.PrefixExpression;
import org.netbeans.jmi.javamodel.PrimaryExpression;
import org.netbeans.jmi.javamodel.VariableAccess;
import org.netbeans.lib.java.parser.ASTree;
import org.netbeans.lib.java.parser.ASTreeTypes;
import org.netbeans.lib.java.parser.ParserTokens;
import org.netbeans.mdr.storagemodel.StorableObject;
import org.netbeans.modules.javacore.parser.ASTProvider;
import java.util.List;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.jmi.javamodel.Variable;


/**
 *
 * @author  Martin Matula
 */
public abstract class VariableAccessImpl extends ElementReferenceImpl implements VariableAccess {
    private boolean hasSuper = false;
    private PrimaryExpression parentClass;
    
    /** Creates a new instance of VariableAccessImpl */
    public VariableAccessImpl(StorableObject o) {
        super(o);
    }
    
    public void setParentClass(PrimaryExpression expression) {
        objectChanged(CHANGED_PARENT_CLASS);
        changeChild(getParentClass(), expression);
        this.parentClass = expression;
    }
    
    public PrimaryExpression getParentClass() {
        if (!childrenInited) {
            initChildren();
        }
        return parentClass;
    }
    
    public boolean getHasSuper() {
        if (isChanged(CHANGED_HAS_SUPER)) {
            return hasSuper;
        } else {
            ASTree tree = getASTree();
            return tree.getType() == ASTreeTypes.FIELD_ACCESS && tree.getSubTrees()[1] != null;
        }
    }
    
    public void setHasSuper(boolean hasSuper) {
        objectChanged(CHANGED_HAS_SUPER);
        this.hasSuper = hasSuper;
    }
    
    public List getChildren() {
        List list = new ArrayList(1);
        addIfNotNull(list, getParentClass()); 
        return list;
    }
    
    protected void initChildren() {
        childrenInited = false;
        ASTree tree = getASTree();
        if (tree != null) {
            if (tree.getType() == ParserTokens.IDENTIFIER) {
                parentClass = null;
            } else {
                parentClass = (PrimaryExpression) initOrCreate(parentClass, tree.getSubTrees()[0]);
            }
        }
        childrenInited = true;
    }
    
    protected ASTree getNameAST() {
        ASTree tree = getASTree();
        if (tree.getType() == ParserTokens.IDENTIFIER) {
            return tree;
        } else if (tree.getType() == ASTreeTypes.MULTI_PART_ID) {
            return tree.getSubTrees()[1];
        } else {
            return tree.getSubTrees()[2];
        }
    }
    
    public Type getType() {
        Object semInfo = getParser().getSemanticInfo(getASTree(), this);
        
        if (semInfo instanceof Variable)
            return ((Variable)semInfo).getType();
        return (Type)semInfo;
    }
    
    public String getSourceText() {
        String origElem;
        if ((origElem = checkChange()) != null)
            return origElem;
        StringBuffer buf = new StringBuffer();
        boolean hasSuper = getHasSuper ();
        StatementImpl parentClass = (StatementImpl) getParentClass();
        if (parentClass != null) {
            buf.append(parentClass.getSourceText());
            buf.append("."); // NOI18N
        }
        if (hasSuper) {
            buf.append("super."); // NOI18N
        }
        buf.append(getName());            
        return buf.toString();
    }

    public void getDiff(List diff) {
        ASTProvider parser = getParser();
        ASTree tree = getASTree();

        MetadataElement parentClass = (MetadataElement) getParentClass();
        if (isChanged(CHANGED_HAS_SUPER | CHANGED_PARENT_CLASS) || (parentClass != null && parentClass.isChanged())) {
            replaceNode(diff, parser, tree, getSourceText(), 0, null);
        } else {
            if (isChanged(CHANGED_NAME)) {
                replaceNode(diff, parser, getNameAST(), getName(), 0, null);
            }
        }
    }
    
    void setData(String name, PrimaryExpression parentClass, boolean hasSuper) {
        setData(name);
        changeChild(null, parentClass);
        this.parentClass = parentClass;
        this.hasSuper = hasSuper;
    }

    protected void _delete() {
        // --- delete components -------------------------------------------
        if (childrenInited) {
            deleteChild(parentClass);
        }
        // --- delete links -----------------------------------------------
        // no links to delete
        // --- call super ---------------------------------------
        super._delete();
    }
        
    public void replaceChild(Element oldElement,Element newElement) {
        if (childrenInited) {
            if (oldElement.equals(parentClass)) {
                setParentClass((PrimaryExpression)newElement);
            }
        }
    }
    
    public Element duplicate(JavaModelPackage targetExtent) {
        return targetExtent.getVariableAccess().createVariableAccess(
                getName(), (PrimaryExpression) duplicateElement(getParentClass(), targetExtent), getHasSuper());
    }

    public boolean isRead() {        
        Element parent = (Element) refImmediateComposite();
        if (parent instanceof Assignment) {
            Assignment assign=(Assignment)parent;
            
            if (assign.getLeftSide().equals(this) && assign.getOperator().equals(OperatorEnum.ASSIGN))
                return false;
        }
        return true;
    }

    public boolean isWrite() {
        Element parent = (Element) refImmediateComposite();
        if (parent instanceof Assignment) {
            Assignment assign=(Assignment)parent;
            
            if (assign.getLeftSide().equals(this))
                return true;
        } else if (parent instanceof PrefixExpression) { // prefix or postfix expression
            PrefixExpression exp=(PrefixExpression)parent;
            Operator op=exp.getOperator();
            
            if (op.equals(OperatorEnum.INC) || op.equals(OperatorEnum.DEC))
                return true;
        }
        return false;
    }
}
