/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.parser;

import org.netbeans.lib.java.parser.ASTree;
import org.netbeans.lib.java.parser.ASTreeTypes;
import org.netbeans.lib.java.parser.ParserTokens;
import org.netbeans.lib.java.parser.Token;


/**
 *
 * @author  Martin Matula
 */
public class ASTUtil implements ASTreeTypes, ParserTokens {
    
    private static final String[] EMPTY_STRING_ARRAY=new String[0];
    
    /** Creates a new instance of ASTUtil */
    private ASTUtil() {
    }    

    public static String getIdentifier(ASTree tree) {
        switch (tree.getType()) {
            case IDENTIFIER:
                return (String) ((Token) tree).getValue();
            case MULTI_PART_ID: {
                ASTree parts[] = tree.getSubTrees();
                
                return getIdentifier(parts[0]).concat(".").concat(getIdentifier(parts[1])); // NOI18N
            }
        }
        return null;
    }
}
