/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.parser;

import org.netbeans.lib.java.parser.ASTree;
import org.netbeans.lib.java.parser.ASTreeTypes;
import org.netbeans.modules.javacore.jmiimpl.javamodel.AnnotationImpl;

/**
 * @author Tomas Hurka
 * @author Pavel Flaska
 */
public final class AnnotationInfo extends ElementInfo {
    public static final int ANNOTATION_TYPE = ASTreeTypes.ANNOTATION;
    public AnnotationValueInfo[] values;
    public NameRef type;
    
    public AnnotationInfo(ASTree tree, int infoType, NameRef name, AnnotationValueInfo[] values) {
        super(tree, infoType, null);
        this.values = values == null ? EMPTY_ANNOTATION_VALUES : values;
        type=name;
    }

    public void doAttribution(AnnotationImpl parent) {
        assert parent.getElementInfo() == this;
        ((ResourceInfo) resource.getElementInfo()).doAttribution(parent);
    }
}
