/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.parser;

import java.util.Arrays;
import org.netbeans.modules.javacore.jmiimpl.javamodel.AnnotationImpl;
import org.netbeans.modules.javacore.jmiimpl.javamodel.SemiPersistentElement;

/**
 * @author Tomas Hurka
 * @author Pavel Flaska
 */
public final class AnnotationInfoMeasure implements Measure {
    public static final AnnotationInfoMeasure INSTANCE = new AnnotationInfoMeasure();

    private AnnotationInfoMeasure() {
    }
    
    /** Compares Annoation to AnnotationInfo object.
     * @param refObject Must be Annoation
     * @param AnnotationInfo
     * @return distance
     */
    public int getDistance(Object refObject, Object ast) {
        if (ast instanceof AnnotationInfo) {
            AnnotationInfo astInfo = (AnnotationInfo) ast;
            AnnotationImpl refInfo = (AnnotationImpl) refObject;
            int result = INFINITE_DISTANCE;

            if (refInfo.isPersisted()) {
                result = ClassNameMeasure.INSTANCE.getDistance(refInfo.getTypeRef(), astInfo.type);
            }
            return result;
        }
        return INFINITE_DISTANCE;
    }
}
