/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *   
 *  You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *    
 *  The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 *  Microsystems, Inc. All Rights Reserved.
 *  
 */
package org.netbeans.modules.javacore.parser;

import org.netbeans.lib.java.parser.ASTree;
import org.openide.util.Utilities;

public class AnnotationValueInfo extends ElementInfo {
    public static final int ANNOTATIONVALUE_ANNOTATION = 0x1000;
    public static final int ANNOTATIONVALUE_STRING = 0x1001;
    public static final int ANNOTATIONVALUE_ARRAY = 0x1002;
    
    public Object value;
    
    /** Creates a new instance of AnnotationValueInfo */
    public AnnotationValueInfo(ASTree tree, int infoType, String name, Object val) {
        super(tree, infoType, name);
        value = val;
    }
    
    public boolean equals(Object obj) {
        if (!(obj instanceof AnnotationValueInfo)) return false;
        AnnotationValueInfo info = (AnnotationValueInfo) obj;
        return Utilities.compareObjects(name, info.name) && Utilities.compareObjects(value, info.value);
    }
    
}
