/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
/*
 * ArrayMapper.java
 *
 * Created on January 6, 2003, 3:27 PM
 */

package org.netbeans.modules.javacore.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.netbeans.jmi.javamodel.*;
import org.openide.ErrorManager;

/**
 *
 * @author  Tomas Hurka
 */
public class ArrayMapper {
    private Object[] oldArr;
    private Object[] newArr;
    private int[] map;
    private List deleted;
    private List added;
    private boolean identical;
    
    public ArrayMapper(Object[] o,Object[] n) {
        oldArr=new Object[o.length];
        System.arraycopy(o,0,oldArr,0,o.length);
        newArr=n;
    }
    
    public int[] getMap() {
        if (map==null)
            mapArray();
        return map;
    }
    
    public boolean isIdentical() {
        if (map==null)
            mapArray();
        return identical;
    }
    
    public List getDeletedIndexes() {
        if (deleted==null) {
            int i;
            
            if (map==null)
                mapArray();
            deleted=new ArrayList();
            for (i=0;i<oldArr.length;i++) {
                Object obj=oldArr[i];
                
                if (obj!=null)
                    deleted.add(new Integer(i));
            }
        }
        return deleted;
    }
    
    List getAdded() {
        if (added==null) {
            int i;
            
            if (map==null)
                mapArray();
            added=new ArrayList();
            for (i=0;i<map.length;i++) {
                if (map[i]==-1)
                    added.add(newArr[i]);
            }
        }
        return added;
    }
    
    private class DistanceInfo implements Comparable {
        private final int newIndex,oldIndex,distance;
        
        private DistanceInfo(final int newI, final int oldI, final int dis) {
            newIndex=newI;
            oldIndex=oldI;
            distance=dis;
        }
        
        public final int compareTo(Object obj) {
            return distance-((DistanceInfo)obj).distance;
        }
    }
    
    private final void mapArray() {
        List distances=new ArrayList(oldArr.length*2);
        int i,mapped=0,identicalObjects=0;
        
        map=new int[newArr.length];
        Arrays.fill(map,-1);
        for (i=0;i<newArr.length;i++) {
            Object newObj=newArr[i];
            int j;
            List currentDistances=new ArrayList(oldArr.length/2);
            
            for (j=0;j<oldArr.length;j++) {
                int oldIndex=(i+j)%oldArr.length;
                Object oldObj=oldArr[oldIndex];
                
                if (oldObj!=null) {
                    int dis=getDistance(oldObj,newObj);
                    
                    if (dis==0) {
                        if (i==oldIndex)
                            identicalObjects++;
                        map[i]=oldIndex;
                        oldArr[oldIndex]=null;
                        mapped++;
                        break;
                    }
                    if (dis<Measure.INFINITE_DISTANCE)
                        currentDistances.add(new DistanceInfo(i,oldIndex,dis));
                }
            }
            if (j==oldArr.length)
                distances.addAll(currentDistances);
        }
        if (mapped!=oldArr.length) {
            DistanceInfo[] sortedDistances=new DistanceInfo[distances.size()];
            int j;
            
            Collections.sort(distances);
            sortedDistances=(DistanceInfo[])distances.toArray(sortedDistances);
            for (j=0;j<sortedDistances.length;j++) {
                DistanceInfo info=sortedDistances[j];
                int oldIndex=info.oldIndex;
                
                if (oldArr[oldIndex]!=null && map[info.newIndex]==-1) {
                    if (info.newIndex==oldIndex)
                        identicalObjects++;
                    map[info.newIndex]=oldIndex;
                    oldArr[oldIndex]=null;
                    if (++mapped==oldArr.length)
                        break;
                }
            }
        }
        identical=(identicalObjects==oldArr.length && oldArr.length==newArr.length);
    }
    
    private static int getDistance(Object mdr,Object ast) {
        Measure measure=null;
        
        if (mdr instanceof EnumConstant)
            measure=EnumConstInfoMeasure.INSTANCE;
        else if (mdr instanceof Initializer)
            measure=InitializerInfoMeasure.INSTANCE;
        else if (mdr instanceof Import)
            measure=ImportInfoMeasure.INSTANCE;
        else if (mdr instanceof Parameter)
            measure=ParameterInfoMeasure.INSTANCE;
        else if (mdr instanceof FieldGroup)
            measure=FieldGroupInfoMeasure.INSTANCE;
        else if (mdr instanceof TypeParameter)
            measure=TypeParamInfoMeasure.INSTANCE;
        else if (mdr instanceof Field)    
            measure=FieldInfoMeasure.INSTANCE;
        else if (mdr instanceof Method)
            measure=MethodInfoMeasure.INSTANCE;
        else if (mdr instanceof Constructor)
            measure=ConstructorInfoMeasure.INSTANCE;
        else if (mdr instanceof JavaEnum)
            measure=EnumInfoMeasure.INSTANCE;
        else if (mdr instanceof AnnotationType)
            measure=AnnotationTypeInfoMeasure.INSTANCE;
        else if (mdr instanceof Annotation)
            measure=AnnotationInfoMeasure.INSTANCE;
        else if (mdr instanceof Attribute)
            measure=AttributeInfoMeasure.INSTANCE;
        else if (mdr instanceof JavaClass)
            measure=ClassInfoMeasure.INSTANCE;
        else if (mdr instanceof AttributeValue)
            measure=AnnotationValueInfoMeasure.INSTANCE;
        else {
            ErrorManager.getDefault().log(ErrorManager.EXCEPTION,"Unknown type "+mdr.getClass());
            return Measure.INFINITE_DISTANCE;
        }
        return measure.getDistance(mdr,ast);
    }

    public boolean hasPermutation() {
        int i;
        int val=-1;
        final int map[]=getMap();
        
        for (i=0;i<map.length;i++) {
            final int mp=map[i];
            
            if (mp!=-1) {
                if (mp>val)
                    val=mp;
                else
                    return true;
            }
        }
        return false;
    }
}

