/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

/**
 *
 * @author  Martin Matula
 */
class ArrayMeasure implements Measure {
    private final Measure measure;
    
    ArrayMeasure(Measure elementsMeasure) {
        measure = elementsMeasure;
    }
    
    public int getDistance(Object first, Object second) {
        Object[] firstArr=(Object[])first;
        Object[] secondArr=(Object[])second;
        int maxLength=Math.max(firstArr.length, secondArr.length);
        
        if (maxLength!=0) {
            List array1 = new ArrayList(Arrays.asList(firstArr));
            List array2 = new ArrayList(Arrays.asList(secondArr));
            int minDistance = INFINITE_DISTANCE;
            Object minDistanceElement = null;
            int error = 0;
            
            for (Iterator it1 = array1.iterator(); it1.hasNext();) {
                Object element1 = it1.next();
                for (Iterator it2 = array2.iterator(); it2.hasNext();) {
                    Object element2 = it2.next();
                    int distance = measure.getDistance(element1, element2);
                    if (distance == 0) {
                        it1.remove();
                        it2.remove();
                        break;
                    }
                }
            }
            for (Iterator it1 = array1.iterator(); it1.hasNext();) {
                Object element1 = it1.next();
                for (Iterator it2 = array2.iterator(); it2.hasNext();) {
                    Object element2 = it2.next();
                    int distance = measure.getDistance(element1, element2);
                    if (distance < minDistance) {
                        minDistance = distance;
                        minDistanceElement = element2;
                    }
                }
                if (minDistanceElement != null) {
                    array2.remove(minDistanceElement);
                    it1.remove();
                    minDistanceElement = null;
                    error += minDistance;
                }
            }
            error += INFINITE_DISTANCE * Math.max(array1.size(), array2.size());
            error = 2 * error / maxLength;
            return error > INFINITE_DISTANCE ? INFINITE_DISTANCE : error;
        }
        return 0;
    }
}
