/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.javacore.parser;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.netbeans.mdr.storagemodel.StorableBaseObject;
import org.netbeans.mdr.util.IOUtils;

public class ArrayRef extends TypeRef {
    public final PrimitiveTypeRef parent;
    public final int dimCount;
    
    private int hashCode;
    
    public static Object read(InputStream stream, StorableBaseObject storable) throws IOException {
        return new ArrayRef((PrimitiveTypeRef) IOUtils.read(stream, storable), IOUtils.readInt(stream));
    }
    
    public void write(OutputStream outputStream, StorableBaseObject storable) throws IOException {
        IOUtils.write(outputStream, parent, storable);
        IOUtils.writeInt(outputStream, dimCount);
    }
    
    public ArrayRef(PrimitiveTypeRef parent, int dimCount) {
        this.parent = parent;
        this.dimCount = dimCount;
    }

    public boolean equals(Object typeRef) {
        ArrayRef ref;
        
        if (this==typeRef)
            return true;
        if (!(typeRef instanceof ArrayRef))
            return false;
        ref=(ArrayRef)typeRef;
        if (!parent.equals(ref.parent))
            return false;
        return dimCount==ref.dimCount;
    }
    
    String getName() {
        char d[]=new char[dimCount];
            
        Arrays.fill(d,'[');
        return new String(d).concat(parent.getName());
    }
    
    public int hashCode() {
        if (hashCode==0) {
            hashCode=parent.hashCode()^dimCount;
        }
        return hashCode;
    }
}
