/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.parser;

import org.netbeans.lib.java.parser.ASTree;
import org.netbeans.lib.java.parser.ASTreeTypes;
import org.netbeans.modules.javacore.jmiimpl.javamodel.MetadataElement;
import org.netbeans.modules.javacore.jmiimpl.javamodel.SemiPersistentElement;

/**
 *
 * @author Martin Matula
 */
public class ClassInfo extends FeatureInfo {
    public static final int CLASS_TYPE = ASTreeTypes.CLASS_DECLARATION;
    public static final int INTERFACE_TYPE = ASTreeTypes.INTERFACE_DECLARATION;
    public static final int ANON_CLASS_TYPE = ASTreeTypes.CLASS_BODY_DECLARATIONS; 
    public static final int ANNOTATIONTYPE_TYPE = ASTreeTypes.ANNOTATION_TYPE_DECLARATION;

    public final FeatureInfo[] features;
    public final NameRef superclass; // superclass FQN
    public final NameRef[] interfaces;    // interfaces FQNs
    public final TypeParamInfo[] typeParams;

    public ClassInfo(ASTree tree, int infoType, String name, int modifiers, 
                     FeatureInfo[] features, NameRef superclass, NameRef[] interfaces,
                     TypeParamInfo[] typeParams, AnnotationInfo[] annotations) 
    {
        super(tree, infoType, name, modifiers, annotations);
        this.features = features == null ? EMPTY_FEATURES : features;
        this.superclass = superclass;
        this.interfaces = interfaces == null ? EMPTY_NAMEREFS : interfaces;
        this.typeParams = typeParams == null ? EMPTY_TYPE_PARAMS : typeParams;
    }

    public ASTree[] getInterfacesAST(SemiPersistentElement owner) {
        ASTree ifcAST;
        ASTree tree = owner.getASTree();
        if (tree != null) {
            ifcAST = tree.getSubTrees()[4];
        } else {
            ifcAST = null;
        }
        return MetadataElement.getChildNodes(ifcAST, ASTreeTypes.TYPE_LIST);
    }

    public ASTree getTypeAST(SemiPersistentElement owner) {
        ASTree tree = owner.getASTree();
        if (tree != null) {
            ASTree superClass = tree.getSubTrees()[3];
            return superClass == null ? null : superClass.getSubTrees()[0];
        }
        return null;
    }
}
