/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.parser;

import org.netbeans.lib.java.parser.ASTree;
import org.netbeans.lib.java.parser.ASTreeTypes;
import org.netbeans.modules.javacore.jmiimpl.javamodel.SemiPersistentElement;

/**
 *
 * @author Martin Matula
 */
public class FieldInfo extends FeatureInfo {
    public static final int FIELD_TYPE = ASTreeTypes.FIELD_DECLARATION;
    
    public static final int SINGLE_FIELD_INDEX = -1;
    
    public final TypeRef type;   // type FQN 
    public final int index;
    
    public FieldInfo(ASTree tree, int infoType, String name, int modifiers, 
                     TypeRef type, int index, AnnotationInfo[] annotations) 
    {
        super(tree, infoType, name, modifiers, annotations);
        this.type = type;
        this.index = index;
    }

    public ASTree getTypeAST(SemiPersistentElement owner) {
        ASTree tree = owner.getASTree();
        if (tree != null && tree.getType()!=ASTreeTypes.VARIABLE_DECLARATOR) {
            return tree.getSubTrees()[1];
        }
        return null;
    }

}
