/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
/*
 * ImportASTMeasure.java
 *
 * Created on January 10, 2003, 10:15 AM
 */

package org.netbeans.modules.javacore.parser;

import org.netbeans.jmi.javamodel.Import;

/**
 *
 * @author  Tomas Hurka
 */
class ImportInfoMeasure implements Measure {
    static final ImportInfoMeasure INSTANCE = new ImportInfoMeasure();
    
    /** Creates a new instance of ImportASTMeasure */
    private ImportInfoMeasure() {
    }
    
    public int getDistance(Object refObject, Object ast) {
        if (ast instanceof ElementInfo) {
            ElementInfo astInfo = (ElementInfo) ast;
            Import refInfo = (Import) refObject;
            boolean isOnDemand=refInfo.isOnDemand();
            
            if ((isOnDemand && astInfo.infoType==ElementInfo.IMPORT_ON_DEMAND_TYPE) ||
                (!isOnDemand && astInfo.infoType==ElementInfo.SINGLE_IMPORT_TYPE)) {
                return StringMeasure.INSTANCE.getDistance(refInfo.getName(),astInfo.name);
            }
        }
        return INFINITE_DISTANCE;
    }
}
