/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
/*
 * InfoUtil.java
 *
 * Created on November 13, 2003, 2:08 PM
 */

package org.netbeans.modules.javacore.parser;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.jmi.javamodel.CallableFeature;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.modules.javacore.jmiimpl.javamodel.ParameterImpl;

/**
 *
 * @author  Tomas Hurka
 */
class InfoUtil {
    
    /** Creates a new instance of InfoUtil */
    private InfoUtil() {
    }

    static TypeRef[] getTypeNames(CallableFeature call) {
        Object[] pars=call.getParameters().toArray();
        List types=new ArrayList(pars.length);

        for (int i=0;i<pars.length;i++) {
            ParameterImpl par=(ParameterImpl)pars[i];
            
            types.add(par.getTypeRef());
        }
        return (TypeRef[])types.toArray(new TypeRef[pars.length]);
    }
    
    static TypeRef[] getTypeNames(ParameterInfo[] parameters) {
        TypeRef[] typeNames = new TypeRef[parameters.length];
        
        for (int i = 0; i < parameters.length; i++) {
            typeNames[i] = parameters[i].type;
        }
        return typeNames;
    }    

    static String[] getElementNames(ElementInfo[] features) {
        String memberNames[] = new String[features.length];

        for (int i = 0; i < features.length; i++) {
            memberNames[i] = features[i].name;
        }
        return memberNames;
    }
    
    static String[] getElementNames(List featuresList) {
        Object[] features=featuresList.toArray();
        List names=new ArrayList();

        for(int i=0;i<features.length;i++) {
            Feature f=(Feature)features[i];
            
            names.add(f.getName());
        }
        return (String[])names.toArray(new String[names.size()]);
    }
}
