/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.javacore.parser;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.mdr.storagemodel.StorableBaseObject;
import org.openide.util.Utilities;

public class LocalClassNameRef extends NameRef {    
    private int hashCode;
    public String mofId;

    public static Object read(InputStream stream, StorableBaseObject storable) throws IOException {
        throw new UnsupportedOperationException();
    }
    
    public void write(OutputStream outputStream, StorableBaseObject storable) throws IOException {
        throw new UnsupportedOperationException();
    }
    
    public LocalClassNameRef(JavaClass jcls) {
        this(jcls,null,null);
    }
    
    public LocalClassNameRef(JavaClass jcls,TypeParamRef par,TypeRef[] args) {
        super(jcls.getName(),par,args);
        mofId=jcls.refMofId();
    }

    public boolean equals(Object typeRef) {
        LocalClassNameRef ref;
        
        if (this==typeRef)
            return true;
        if (!(typeRef instanceof LocalClassNameRef))
            return false;
        ref=(LocalClassNameRef)typeRef;
        if (!mofId.equals(ref.mofId))
            return false;
        if (!Utilities.compareObjects(parent,ref.parent))
            return false;
        return Utilities.compareObjects(args,ref.args);
    }
    
    String getName() {
        String parentString="";
        
        if (parent!=null) {
            parentString=parent.getName().concat("."); // NOI18N
        }
        return parentString.concat(name);
    }
    
    public int hashCode() {
        if (hashCode!=0) {
            hashCode=mofId.hashCode();
        
            if (parent!=null)
                hashCode^=parent.hashCode();
            hashCode^=args.hashCode();
        }
        return hashCode;
    }
}
