/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
/*
 * MemberClassScope.java
 *
 * Created on March 27, 2003, 3:33 PM
 */

package org.netbeans.modules.javacore.parser;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.modules.javacore.ClassIndex;
import org.netbeans.modules.javacore.jmiimpl.javamodel.JavaClassImpl;

/**
 *
 * @author  Tomas Hurka
 */
public class MemberClassScope implements ScopeMember {
    private String fqn;
    private ClassIndex index;
    private Map inners;
    
    MemberClassScope(JavaClass jclass) {
        if (jclass instanceof JavaClassImpl && ((JavaClassImpl)jclass).isTransient()) { // local class
            JavaClassImpl jclsImpl=(JavaClassImpl)jclass;
            Iterator iter = jclsImpl.getInnerClasses().iterator();
            
            inners=new HashMap();
            while (iter.hasNext()) {
                JavaClass obj = (JavaClass)iter.next ();
                
                inners.put(obj.getSimpleName(),obj);
            } // while

        } else {
            JavaModelPackage pck=(JavaModelPackage)jclass.refImmediatePackage();

            index=ClassIndex.getIndex(pck);
            fqn=jclass.getName().concat("."); // NOI18N
        }
    }
    
    public Object lookup(Object key) {
        if (fqn!=null) {
            String className=fqn.concat((String)key);

            if (index.hasClass(className))
                return className;
            return null;
        }
        return inners.get(key);
    }
}
