/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.parser;

import org.netbeans.lib.java.parser.ASTree;
import org.netbeans.lib.java.parser.ASTreeTypes;
import org.netbeans.modules.javacore.jmiimpl.javamodel.CallableFeatureImpl;
import org.netbeans.modules.javacore.jmiimpl.javamodel.MetadataElement;
import org.netbeans.modules.javacore.jmiimpl.javamodel.SemiPersistentElement;

/**
 *
 * @author Martin Matula
 */
public final class MethodInfo extends FeatureInfo {
    public static final int METHOD_TYPE = ASTreeTypes.METHOD_DECLARATION;
    public static final int CONSTRUCTOR_TYPE = ASTreeTypes.CONSTRUCTOR_DECLARATION;
    
    public final TypeRef type;   // type FQN
    public final ParameterInfo[] parameters;
    public final TypeParamRef[] exceptions;   // exceptions FQNs
    public final TypeParamInfo[] typeParams;

    private CallableFeatureImpl owner = null;

    public MethodInfo(ASTree tree, int infoType, String name, int modifiers, 
                      TypeRef type, ParameterInfo[] parameters, TypeParamRef[] exceptions, 
                      TypeParamInfo[] typeParams, AnnotationInfo[] annotations) 
    {
        super(tree, infoType, name, modifiers, annotations);
        this.type = type;
        this.parameters = parameters == null ? EMPTY_PARAMETERS : parameters;
        this.exceptions = exceptions == null ? EMPTY_TPREFS : exceptions;
        this.typeParams = typeParams == null ? EMPTY_TYPE_PARAMS : typeParams;
    }

    public ASTree[] getExceptionsAST(CallableFeatureImpl owner) {
        ASTree namesAST;
        ASTree tree = owner.getASTree();
        if (tree != null) {
            namesAST = tree.getSubTrees()[4];
        } else {
            namesAST = null;
        }
        return MetadataElement.getChildNodes(namesAST, ASTreeTypes.TYPE_LIST);
    }

    public ASTree getTypeAST(SemiPersistentElement owner) {
        ASTree tree = owner.getASTree();
        if (tree != null) {
            return tree.getSubTrees()[2];
        }
        return null;
    }
}
