/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.javacore.parser;

import java.util.*;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.modules.javacore.ClassIndex;

/**
 * @author  Tomas Hurka
 */
class PackageImpScope implements ScopeMember {
    private String jPackage;
    private ClassPath classPath;
    private Map positiveCache;
    private Set negativeCache;
    
    /** Creates a new instance of PackageImpScope */
    PackageImpScope(String pack,ClassPath cp) {
        jPackage=pack.length()>0?pack.concat("."):pack; // NOI18N
        classPath=cp;
        positiveCache=new HashMap();
        negativeCache=new HashSet();
    }
    
    public Object lookup(Object key) {
        Object val;
        String className;
        JavaClass jcls;
        
        if (negativeCache.contains(key))
            return null;
        val=positiveCache.get(key);
        if (val!=null)
            return val;
        className=jPackage.concat((String)key);
        jcls=ClassIndex.getClassByFqn(className,classPath);
        if (jcls!=null) {
            String name=jcls.getName();
            
            positiveCache.put(key, name);
            return name;
        }
        negativeCache.add(key);
        return null;
    }
}
