/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.parser;

import org.netbeans.lib.java.parser.ASTree;
import org.netbeans.lib.java.parser.ASTreeTypes;
import org.netbeans.modules.javacore.jmiimpl.javamodel.SemiPersistentElement;

/**
 *
 * @author Martin Matula
 */
public final class ParameterInfo extends ElementInfo {
    public static final int PARAMETER_TYPE = ASTreeTypes.FORMAL_PARAMETER;
    
    public final boolean isFinal;
    public final TypeRef type;   // type FQN
    public final boolean isVarArg;
    public final AnnotationInfo[] annotations; 

    public ParameterInfo(ASTree tree, int infoType, String name, boolean isFinal, TypeRef type, boolean isVarArg, AnnotationInfo[] annotations) {
        super(tree, infoType, name);
        this.isFinal = isFinal;
        this.type = type;
        this.isVarArg = isVarArg;
        this.annotations = annotations == null ? EMPTY_ANNOTATIONS: annotations;
    }

    public ASTree getTypeAST(SemiPersistentElement owner) {
        ASTree tree = owner.getASTree();
        if (tree != null) {
            return tree.getSubTrees()[1];
        }
        return null;
    }
}
