/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.javacore.parser;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import org.netbeans.mdr.storagemodel.StorableBaseObject;
import org.netbeans.mdr.util.IOUtils;

public class PrimitiveTypeRef extends TypeRef {
    public final String name;
    
    public static final PrimitiveTypeRef BYTE = new PrimitiveTypeRef("byte"); // NOI18N
    public static final PrimitiveTypeRef SHORT = new PrimitiveTypeRef("short"); // NOI18N
    public static final PrimitiveTypeRef INT = new PrimitiveTypeRef("int"); // NOI18N
    public static final PrimitiveTypeRef LONG = new PrimitiveTypeRef("long"); // NOI18N
    public static final PrimitiveTypeRef CHAR = new PrimitiveTypeRef("char"); // NOI18N
    public static final PrimitiveTypeRef FLOAT = new PrimitiveTypeRef("float"); // NOI18N
    public static final PrimitiveTypeRef DOUBLE = new PrimitiveTypeRef("double"); // NOI18N
    public static final PrimitiveTypeRef BOOLEAN = new PrimitiveTypeRef("boolean"); // NOI18N
    public static final PrimitiveTypeRef VOID = new PrimitiveTypeRef("void"); // NOI18N
    
    private static final HashMap ALL = new HashMap(18);
    
    static {
        ALL.put(new Integer(BYTE.hashCode()), BYTE);
        ALL.put(new Integer(SHORT.hashCode()), SHORT);
        ALL.put(new Integer(INT.hashCode()), INT);
        ALL.put(new Integer(LONG.hashCode()), LONG);
        ALL.put(new Integer(CHAR.hashCode()), CHAR);
        ALL.put(new Integer(FLOAT.hashCode()), FLOAT);
        ALL.put(new Integer(DOUBLE.hashCode()), DOUBLE);
        ALL.put(new Integer(BOOLEAN.hashCode()), BOOLEAN);
        ALL.put(new Integer(VOID.hashCode()), VOID);
    }
    
    public static Object read(InputStream stream, StorableBaseObject storable) throws IOException {
        return ALL.get(new Integer(IOUtils.readInt(stream)));
    }
    
    public void write(OutputStream outputStream, StorableBaseObject storable) throws IOException {
        IOUtils.writeInt(outputStream, hashCode());
    }
    
    public static PrimitiveTypeRef forName(String name) {
        return (PrimitiveTypeRef) ALL.get(new Integer(name.hashCode()));
    }
    
    protected PrimitiveTypeRef(String name) {
        this.name = name;
    }
    
    public boolean equals(Object typeRef) {
        PrimitiveTypeRef ref;
        
        if (this==typeRef)
            return true;
        if (!(typeRef instanceof PrimitiveTypeRef))
            return false;
        ref=(PrimitiveTypeRef)typeRef;
        return name.equals(ref.name);
    }
    
    String getName() {
        return name;
    }
    
    public int hashCode() {
        return name.hashCode();
    }
}