/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.parser;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.lib.java.parser.ASTree;
import org.netbeans.lib.java.parser.ASTreeTypes;
import org.netbeans.modules.javacore.jmiimpl.javamodel.MetadataElement;
import org.netbeans.modules.javacore.jmiimpl.javamodel.ResourceImpl;
import org.netbeans.modules.javacore.jmiimpl.javamodel.SemiPersistentElement;

/**
 *
 * @author Martin Matula
 */
public final class ResourceInfo extends ElementInfo {
    public static final int RESOURCE_TYPE = ASTreeTypes.COMPILATION_UNIT;

    public final ClassInfo[] classes;
    public final ElementInfo[] imports;
    
    private MDRParser hardRef;
    private Set attributed;
    private static final boolean DEBUG = false;

    public ResourceInfo(ASTree tree, int infoType, Resource resource, ClassInfo[] classes, ElementInfo[] imports) {
        super(tree, infoType, resource == null ? null : resource.getName());
        this.classes = classes == null ? EMPTY_FEATURES : classes;
        this.imports = imports == null ? EMPTY_FEATURES : imports;
    }

    public void hardRefAST() {
        hardRef = resource.getParser();
    }

    public void doAttribution(MetadataElement parent) {
        ASTree tree = parent.getASTree();
        if (tree != null) {
            if (attributed == null) {
                attributed = new HashSet();
            }
            if (attributed.add(parent)) {
                MDRParser parser = (MDRParser) tree.getASTContext();
                parser.prepareForAttribution(parent, tree);
            }
        }
    }

    public ASTree refreshASTree() {
        MDRParser mdrParser = ((ResourceImpl) resource).createMDRParser(null, false);
        if (DEBUG) System.err.println("Recreating AST for: " + mdrParser);
        try {
            resource.alreadyChecking = true;
            resource.alreadyCheckingStackTrace = new RuntimeException();
            ResourceInfo resInfo = mdrParser.enterMembers();
            this.tree = resInfo.tree;
        } finally {
            resource.alreadyChecking = false;
        }
        
        if (attributed != null) {
            for (Iterator it = attributed.iterator(); it.hasNext();) {
                MetadataElement entry = (MetadataElement) it.next();
                mdrParser.prepareForAttribution(entry, entry.getASTree());
            }
        }
        
        return mdrParser.getASTree();
    }

    public ASTree getTypeAST(SemiPersistentElement owner) {
        ASTree tree = owner.getASTree();
        if (tree != null) {
            ASTree pkg = tree.getSubTrees()[0];
            return pkg == null ? null : pkg.getSubTrees()[1];
        }
        return null;
    }
}
