/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
/*
 * TokenIterator.java
 *
 * Created on December 4, 2003, 11:59 AM
 */

package org.netbeans.modules.javacore.parser;

import org.netbeans.lib.java.parser.Token;
import org.netbeans.lib.java.parser.Factory;
import org.netbeans.lib.java.parser.JScanner;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

/**
 *
 * @author  Tomas Hurka
 */
public class TokenIterator {
    JScanner scanner;
    ASTProvider provider;
    int tokenIndex;
    Token currentToken;
    
    public TokenIterator(InputStream stream,String sourceLevel) {
	this(new InputStreamReader(stream),sourceLevel);
    }
    
    public TokenIterator(Reader reader,String sourceLevel) {
	this(reader, sourceLevel, false);
    }

    public TokenIterator(InputStream stream,String sourceLevel, boolean liteScan) {
	this(new InputStreamReader(stream),sourceLevel,liteScan);
    }
    
    public TokenIterator(Reader reader,String sourceLevel, boolean liteScan) {
        scanner=Factory.getDefault().getScanner(reader,sourceLevel,liteScan);
    }
    
    public TokenIterator(ASTProvider p) {
        provider=p;
    }
    
    public int getNextTokenType() throws IOException {
        if (scanner!=null) 
            return scanner.yylex();
        try {
            currentToken=provider.getToken(tokenIndex++);
            return currentToken != null ? currentToken.getType() : 0;
        } catch (IndexOutOfBoundsException ex) {
            // end of file
            return 0;
        }
    }
    
    public String getIdentifierText() {
        if (scanner!=null)
            return scanner.yytext();
        return (String)currentToken.getValue();
    }

    public int getIdentifierHash() {
        if (scanner!=null)
            return scanner.yyhash();
        return currentToken.getValue().hashCode();
    }

    /**
     * Returns true if a doc-comment deprecated tag was found.
     */
    public boolean isDeprecated() {
        if (scanner != null) {
	    boolean b = scanner.isDeprecated();
	    scanner.resetDeprecatedFlag();
	    return b;
	}
	return currentToken.getDeprecatedFlag(); 
    }
}
