/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.javacore.parser;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.netbeans.mdr.storagemodel.StorableBaseObject;
import org.netbeans.mdr.util.IOUtils;

public class TypeParamRef extends PrimitiveTypeRef {
    public static Object read(InputStream stream, StorableBaseObject storable) throws IOException {
        return new TypeParamRef(IOUtils.readString(stream));
    }
    
    public void write(OutputStream stream, StorableBaseObject storable) throws IOException {
        IOUtils.writeString(stream, name);
    }
    
    public TypeParamRef(String name) {
        super(name);
    }
    
    public boolean equals(Object typeRef) {
        TypeParamRef ref;
        
        if (this==typeRef)
            return true;
        if (!typeRef.getClass().equals(getClass()))
            return false;
        ref=(TypeParamRef)typeRef;
        return name.equals(ref.name);
    }
    
    public int hashCode() {
        return name.hashCode();
    }
}