/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.javacore.parser;

import org.netbeans.jmi.javamodel.TypeParameter;

/**
 *
 * @author  Tomas Hurka
 */
class TypeParamScope implements ScopeMember {
    private String typeName;
    private TypeParameter typeParam;
    private TypeParamRef typeParamRef;
    
    /** Creates a new instance of SingleImpScope */
    TypeParamScope(String name) {
        typeName=name;
        typeParamRef=new TypeParamRef(name);
    }

    TypeParamScope(TypeParameter tp) {
        this(tp.getName());
        typeParam=tp;
    }
    
    public Object lookup(Object key) {
        if (typeName.equals(key)) {
            if (typeParam==null)
                return typeParamRef;
            return typeParam;
        }
        return null;
    }
}
