/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.javacore.parser;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.netbeans.mdr.storagemodel.StorableBaseObject;
import org.netbeans.mdr.util.IOUtils;
import org.openide.util.Utilities;

public class WildCardRef extends TypeRef {
    public final boolean isLower;
    public final TypeRef bound;
    
    public static Object read(InputStream stream, StorableBaseObject storable) throws IOException {
        return new WildCardRef(IOUtils.readBoolean(stream), (TypeRef) IOUtils.read(stream, storable));
    }
    
    public void write(OutputStream outputStream, StorableBaseObject storable) throws IOException {
        IOUtils.writeBoolean(outputStream, isLower);
        IOUtils.write(outputStream, bound, storable);
    }
    
    public WildCardRef(boolean isLower, TypeRef bound) {
        this.isLower = isLower;
        this.bound = bound;
    }

    public boolean equals(Object typeRef) {
        WildCardRef ref;
        
        if (this==typeRef)
            return true;
        if (!(typeRef instanceof WildCardRef))
            return false;
        ref=(WildCardRef)typeRef;
        if (isLower!=ref.isLower)
            return false;
        return Utilities.compareObjects(bound, ref.bound);
    }
    
    String getName() {
        return (isLower? "+" : "-").concat(bound == null ? "" : bound.getName()); // NOI18N
    }
    
    public int hashCode() {
        return bound == null ? 0 : bound.hashCode();
    }
}