/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.javacore.scanning;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.openide.ErrorManager;

/**
 *
 * @author  thurka
 */
class FileEntry implements FileInfo {
    private File file;
    private String path;
    
    /** Creates a new instance of FileEntry */
    public FileEntry(File f,String p) {
        file=f;
        path=p;
    }

    public InputStream getInputStream() throws FileNotFoundException {
        return new FileInputStream(file);
    }

    public String getName() {
        return file.getName();
    }

    public boolean isDirectory() {
        return file.isDirectory();
    }

    public long lastModified() {
        return file.lastModified();
    }

    public FileInfo[] listFiles() {
        if (isDirectory()) {
            File[] files=file.listFiles();
            
            if (files!=null) {
                int i;
                FileInfo[] infos=new FileInfo[files.length];
                String pathPrefx=path;

                if (path.length()>0)
                    pathPrefx=path.concat("/"); // NOI18N
                for (i=0;i<infos.length;i++) {
                    File f=files[i];

                    infos[i]=new FileEntry(f,pathPrefx.concat(f.getName()));
                }
                return infos;
            }
        }
        return EMPTY_ARR;
    }

    public String getPath() {
        return path;
    }

    public String getCanonicalName() {
        try {
            return file.getCanonicalPath();
        } catch (IOException ex) {
            ErrorManager.getDefault().notify(ErrorManager.INFORMATIONAL, ex);
            return getName();
        }
    }
}
