/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */


package org.netbeans.modules.javacore.scanning;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

/**
 *
 * @author  thurka
 */
class ZipDirInfo implements FileInfo {
    private List files=new ArrayList();
    private String name;
    private String path;
    /** Creates a new instance of ZipDirInfo */
    public ZipDirInfo(String p,String n) {
        name=n;
        path=p;
    }

    public InputStream getInputStream() {
        throw new UnsupportedOperationException();
    }

    public String getName() {
        return name;
    }
    
    public String getPath() {
        return path;
    }
    
    public boolean isDirectory() {
        return true;
    }

    public long lastModified() {
        throw new UnsupportedOperationException();       
    }

    public FileInfo[] listFiles() {
        return (FileInfo[])files.toArray(new FileInfo[files.size()]);
    }
    
     void addEntry(ZipFile file,ZipEntry entry,String shortName, String pathName) {
        files.add(new ZipEntryInfo(file,entry,shortName, pathName));
    }
    
    void addDir(ZipDirInfo dirInfo) {
        files.add(dirInfo);
    }

    public String getCanonicalName() {
        return null;
    }
}
