/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.javacore.scanning;
import java.io.IOException;

import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
/**
 *
 * @author  thurka
 */
class ZipEntryInfo implements FileInfo {
    private ZipEntry entry;
    private ZipFile file;
    private String name;
    private String path;

    public ZipEntryInfo(ZipFile f,ZipEntry en,String shortName, String pathToRoot) {
        entry=en;
        file=f;
        name=shortName;
        path = pathToRoot;
    }

    public InputStream getInputStream() throws IOException {
        return file.getInputStream(entry);
    }

    public String getName() {
        return name;
    }

    public boolean isDirectory() {
        return false;
    }

    public long lastModified() {
        return entry.getTime();
    }

    public FileInfo[] listFiles() {
        return EMPTY_ARR;
    }

    public String getPath() {
        return path;
    }

    public String getCanonicalName() {
        return null;
    }
}
