/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.jmi.javamodel;

import java.util.HashMap;
import java.util.Iterator;
import junit.textui.TestRunner;
import org.netbeans.junit.NbTestCase;
import org.netbeans.junit.NbTestSuite;
 

public class FeaturesTest extends NbTestCase {
   
    /** Need to be defined because of JUnit */
    public FeaturesTest(String name) {
        super(name);
        
    } 
    
    public static NbTestSuite suite() {
        NbTestSuite suite = new NbTestSuite();
        suite.addTest(new FeaturesTest("testAllFeatures"));
        return suite;
    }
    
    /** Use for execution inside IDE */
    public static void main(java.lang.String[] args) {
        TestRunner.run(suite());
    }

    String cbn;
    HashMap classes;
    int numOfFeaturesInClasses;
    
    protected void setUp() {
//        ResourceImpl.READ_ONLY = true;
        
        cbn = "testsrc";
        
        classes = new HashMap();
        classes.put("junit.framework.Assert", new Integer(39));
        classes.put("junit.framework.AssertionFailedError", new Integer(2));
        classes.put("junit.framework.ComparisonFailure", new Integer(4));
        classes.put("junit.framework.Protectable", new Integer(1));
        classes.put("junit.framework.Test", new Integer(2));
        classes.put("junit.framework.TestCase", new Integer(14));
        classes.put("junit.framework.TestFailure", new Integer(9));
        classes.put("junit.framework.TestListener", new Integer(4));
        classes.put("junit.framework.TestResult", new Integer(23));
        classes.put("junit.framework.TestSuite", new Integer(24));
        
        numOfFeaturesInClasses = classes.size();
        for (Iterator it = classes.values().iterator(); it.hasNext(); ) {
            numOfFeaturesInClasses += ((Integer)it.next()).intValue();
        }
    }
    
    
    public void testAllFeatures() {/*
        Utility.beginTrans(false);
        try {
            JavaModelPackage pkg = Utility.getJavaModelPackage(cbn);
            HashMap featuresInClasses = new HashMap();
            for (Iterator it = classes.keySet().iterator(); it.hasNext(); ) {
                String className = (String) it.next();
                JavaClass javaClass = (JavaClass) pkg.getType().resolve(className);
                assertNotNull(className+" class instance", javaClass);
                featuresInClasses.put(javaClass, new Integer(0));
            }
            
            Collection features = pkg.getFeature().refAllOfType();
            int numOfFeatures = 0;
            int numOfFeaturesWithoutDeclaringClass = 0;
            for (Iterator it = features.iterator(); it.hasNext(); ) {
                ++numOfFeatures;
                FeatureImpl feature = (FeatureImpl) it.next();
                
                JavaClass javaClass = (JavaClass) feature.getDeclaringClass();
                if (javaClass == null) {
                    ++numOfFeaturesWithoutDeclaringClass;
                    continue;
                }
                
                Integer n = (Integer) featuresInClasses.get(javaClass);
                if (n != null) {
                    featuresInClasses.put(javaClass, new Integer(n.intValue()+1)); 
                }
            }
            
            //assertEquals("Total number of features", numOfFeaturesInClasses, numOfFeatures);
            System.out.println("Total number of features: "+numOfFeatures);
            //assertEquals("Total number of features without declaring class: ", classes.size(), numOfFeaturesWithoutDeclaringClass);
            System.out.println("Total number of features without declaring class: "+numOfFeaturesWithoutDeclaringClass);
            
            for (Iterator it = featuresInClasses.entrySet().iterator(); it.hasNext(); ) {
                Map.Entry entry = (Map.Entry) it.next();
                JavaClass javaClass = (JavaClass) entry.getKey();
                int numOfFeaturesInClass = ((Integer) entry.getValue()).intValue();
                int expectedNumOfFeaturesInClass = ((Integer) classes.get(javaClass.getName())).intValue();
                assertEquals("Number of features in "+javaClass.getName(), expectedNumOfFeaturesInClass, numOfFeaturesInClass);
            }
        }
        finally  {
            Utility.endTrans();
        }*/
    }
    
}
