/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.jmi.javamodel;

import java.util.*;
import javax.jmi.reflect.RefAssociation;
import javax.jmi.reflect.RefAssociationLink;
import junit.textui.TestRunner;
import org.netbeans.junit.NbTestCase;
import org.netbeans.junit.NbTestSuite;
import org.netbeans.modules.javacore.jmiimpl.javamodel.ImplementsImpl;
import org.netbeans.jmi.javamodel.codegen.Utility;
 

/** 
 * @author Vladimir Hudec
 * 
 * [TODO]: anonymous classes should be also considered
 */
public class ImplementsTest extends NbTestCase {
   
    /** Need to be defined because of JUnit */
    public ImplementsTest(String name) {
        super(name);
        
    } 
    
    public static NbTestSuite suite() {
        NbTestSuite suite = new NbTestSuite();
        suite.addTest(new ImplementsTest("testAllLinks"));
        suite.addTest(new ImplementsTest("testNullArguments"));
        suite.addTest(new ImplementsTest("testImproperArguments"));
        suite.addTest(new ImplementsTest("testAddRemoveAssociation"));
        suite.addTest(new ImplementsTest("testAddRemoveInterface"));
        suite.addTest(new ImplementsTest("testAddRemoveImplementor"));
        return suite;
    }
    
    /** Use for execution inside IDE */
    public static void main(java.lang.String[] args) {
        TestRunner.run(suite());
    }

    JavaModelPackage pkg;
    ImplementsImpl implementsImpl;
    int implementsNumOfClassesInterfaces;
    int implementsNumOfInterfacesImplementors;
    JavaClass class1, class2, class3, interface1, interface2, interface3;
    int class1NumOfInterfaces, class2NumOfInterfaces, class3NumOfInterfaces;
    int interface1NumOfImplementors, interface2NumOfImplementors, interface3NumOfImplementors;
    
    protected void setUp() {
        class1 = Utility.findClass("org.netbeans.test.classes.Class1");
        pkg = (JavaModelPackage) class1.refImmediatePackage();
        implementsImpl = (ImplementsImpl) pkg.getImplements();
        try { Thread.sleep(2000); } catch (Exception ex) {}
        
        assertNotNull("Class1", class1);
        assertFalse("Class1 is instance of UnresolvedClass", class1 instanceof UnresolvedClass);
        class2 = Utility.findClass("org.netbeans.test.classes.Class2");
        assertNotNull("Class2", class2);
        assertFalse("Class2 is instance of UnresolvedClass", class2 instanceof UnresolvedClass);
        class3 = Utility.findClass("org.netbeans.test.classes.Class3");
        assertNotNull("Class3", class3);
        assertFalse("Class3 is instance of UnresolvedClass", class3 instanceof UnresolvedClass);
        interface1 = Utility.findClass("org.netbeans.test.interfaces.Interface1");
        assertNotNull("Interface1", interface1);
        assertFalse("Interface1 is instance of UnresolvedClass", interface1 instanceof UnresolvedClass);
        interface2 = Utility.findClass("org.netbeans.test.interfaces.Interface2");
        assertNotNull("Interface2", interface2);
        assertFalse("Interface2 is instance of UnresolvedClass", interface2 instanceof UnresolvedClass);
        interface3 = Utility.findClass("org.netbeans.test.interfaces.Interface3");
        assertNotNull("Interface3", interface3);
        assertFalse("Interface3 is instance of UnresolvedClass", interface3 instanceof UnresolvedClass);

        // Class1 implements Interface1
        // Class2 extends Class1 implements Interface2
        // Class3.Class4 implements Interface1
        // Interface3 extends Interface1, Interface2 ->
        //   Interface3 implements Interface1
        //   Interface3 implements Interface1
        implementsNumOfClassesInterfaces = 5;
        implementsNumOfInterfacesImplementors = 5;
        class1NumOfInterfaces = 1;
        class2NumOfInterfaces = 1;
        class3NumOfInterfaces = 0;
        interface1NumOfImplementors = 3;
        interface2NumOfImplementors = 2;
        interface3NumOfImplementors = 0;

        checkNumber("Class1 interfaces", class1NumOfInterfaces, class1.getInterfaces());
        checkNumber("Class2 interfaces", class2NumOfInterfaces, class2.getInterfaces());
        checkNumber("Class3 interfaces", class3NumOfInterfaces, class3.getInterfaces());
        checkNumber("Interface1 implementors", interface1NumOfImplementors, interface1.getImplementors());
        checkNumber("Interface2 implementors", interface2NumOfImplementors, interface2.getImplementors());
        checkNumber("Interface3 implementors", interface3NumOfImplementors, interface3.getImplementors());
    }
    
    protected void printAllLinks(RefAssociation refAssociation) {
        Collection impls = refAssociation.refAllLinks();
        int numOfLinks = 0;
        for (Iterator it = impls.iterator(); it.hasNext(); ) {
            numOfLinks++;
            RefAssociationLink link = (RefAssociationLink) it.next();
            JavaClass superInterface = (JavaClass) link.refFirstEnd();
            JavaClass implementor = (JavaClass) link.refSecondEnd();
            System.out.println("  #"+numOfLinks+": "+implementor.getName()+" implements "+superInterface.getName());
        }
    }
    
    protected void checkNumber(String msg, int expectedValue, int actualValue) {
        assertEquals("Total number of "+msg, expectedValue, actualValue);
    }
    
    protected void checkNumber(String msg, int expectedValue, Collection coll) {
        if (expectedValue == 0) {
            assertTrue("Total number of "+msg, coll.isEmpty());
        }
        else {
            checkNumber(msg, expectedValue, coll.size());
        }
    }
    
    public void testAllLinks() {
        Utility.beginTrans(false);
        try {
            Collection impls = implementsImpl.refAllLinks();
            int numOfLinks = 0;
            int numOfClassIntefaces = 0;
            int numOfInterfaceImplementors = 0;
            
            String packageOfClasses = class1.getResource().getPackageName();
            String packageOfInterfaces = interface1.getResource().getPackageName();
            
            for (Iterator it = impls.iterator(); it.hasNext(); ) {
                numOfLinks++;
                RefAssociationLink link = (RefAssociationLink) it.next();
                JavaClass superInterface = (JavaClass) link.refFirstEnd();
                JavaClass implementor = (JavaClass) link.refSecondEnd();
                if (implementor.getName().startsWith(packageOfClasses) || implementor.getName().startsWith(packageOfInterfaces))
                    ++numOfClassIntefaces;
                if (superInterface.getName().startsWith(packageOfClasses) || superInterface.getName().startsWith(packageOfInterfaces))
                    ++numOfInterfaceImplementors;
                System.out.println("  #"+numOfLinks+": "+implementor.getName()+" implements "+superInterface.getName());
            }
            
            checkNumber("classes interfaces", implementsNumOfClassesInterfaces, numOfClassIntefaces);
            checkNumber("interfaces implementors", implementsNumOfInterfacesImplementors, numOfInterfaceImplementors);
        }
        finally  {
            Utility.endTrans();
        }
    }
    
    public void testNullArguments() {
        String msg = "Association's operation with null argument should throw exception";
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            try {
                implementsImpl.exists(null, class1);
                fail(msg+" (exists)");
            }
            catch (NullPointerException ex) {
            }
            try {
                implementsImpl.exists(interface1, null);
                fail(msg+" (exists)");
            }
            catch (NullPointerException ex) {
            }
            try {
                implementsImpl.add(null, class1);
                fail(msg+" (add)");
            }
            catch (NullPointerException ex) {
            }
            try {
                implementsImpl.add(interface1, null);
                fail(msg+" (add)");
            }
            catch (NullPointerException ex) {
            }
            try {
                implementsImpl.remove(null, class1);
                fail(msg+" (remove)");
            }
            catch (NullPointerException ex) {
            }
            try {
                implementsImpl.remove(interface1, null);
                fail(msg+" (remove)");
            }
            catch (NullPointerException ex) {
            }
            try {
                implementsImpl.getImplementors(interface1).add(null);
                fail(msg+" (getImplementors.add)");
            }
            catch (NullPointerException ex) {
            }
            try {
                implementsImpl.getImplementors(interface3).iterator().remove();
                fail(msg+" (getImplementors.iterator.remove)");
            }
            catch (IllegalStateException ex) {
            }
            catch (NullPointerException ex) {
                // [TODO] - fix in ReferenceCol/ListWrapper
            }
            
            fail = false;
        }
        finally  {
            Utility.endTrans(fail);
        }
    }
    
    public void testImproperArguments() {
        String msg = "Association's operation with improper argument should throw exception";

        Object obj = new Object();
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            try {
                implementsImpl.getImplementors(interface1).add(obj);
                fail(msg+" (getImplementors.add)");
            }
            catch (javax.jmi.reflect.TypeMismatchException ex) {
            }
            
            fail = false;
        }
        finally  {
            Utility.endTrans(fail);
        }

        fail = true;
        Utility.beginTrans(true);
        try {
            try {
                implementsImpl.getInterfaces(class1).add(obj);
                fail(msg+" (getInterfaces.add)");
            }
            catch (javax.jmi.reflect.TypeMismatchException ex) {
            }
            
            fail = false;
        }
        finally  {
            Utility.endTrans(fail);
        }

        fail = true;
        Utility.beginTrans(true);
        try {
            try {
                implementsImpl.add(interface1, class1);
                fail(msg+" (Adding existing association)");
            }
            catch (javax.jmi.reflect.WrongSizeException ex) {
            }
            
            fail = false;
        }
        finally  {
            Utility.endTrans(fail);
        }

        fail = true;
        Utility.beginTrans(true);
        try {
            boolean result = implementsImpl.remove(interface2, class1);
            assertFalse("Trying remove nonexisting association", result);
            
            fail = false;
        }
        finally  {
            Utility.endTrans(fail);
        }
    }
    
    public void testAddRemoveAssociation() {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            implementsImpl.add(interface2, class1);
            
            checkNumber("Class1 interfaces", class1NumOfInterfaces+1, class1.getInterfaces());
            checkNumber("Interface2 implementors", interface2NumOfImplementors+1, interface2.getImplementors());
            
            fail = false;
        }
        finally  {
            Utility.endTrans(fail);
        }
        
        fail = true;
        Utility.beginTrans(true);
        try {
            implementsImpl.remove(interface2, class1);
            
            checkNumber("Class1 interfaces", class1NumOfInterfaces, class1.getInterfaces());
            checkNumber("Interface2 implementors", interface2NumOfImplementors, interface2.getImplementors());
            
            fail = false;
        }
        finally  {
            Utility.endTrans(fail);
        }
    }
    
    public void testAddRemoveInterface() {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            List interfaces = implementsImpl.getInterfaces(class1);
            interfaces.add(interface2);
            
            checkNumber("Class1 interfaces", class1NumOfInterfaces+1, class1.getInterfaces());
            checkNumber("Interface2 implementors", interface2NumOfImplementors+1, interface2.getImplementors());
            
            fail = false;
        }
        finally  {
            Utility.endTrans(fail);
        }
        
        fail = true;
        Utility.beginTrans(true);
        try {
            List interfaces = implementsImpl.getInterfaces(class1);
            interfaces.remove(interface2);
            
            checkNumber("Class1 interfaces", class1NumOfInterfaces, class1.getInterfaces());
            checkNumber("Interface2 implementors", interface2NumOfImplementors, interface2.getImplementors());
            
            fail = false;
        }
        finally  {
            Utility.endTrans(fail);
        }

        fail = true;
        Utility.beginTrans(true);
        try {
            List interfaces = implementsImpl.getInterfaces(class1);
            List list = new ArrayList();
            list.add(interface2);
            list.add(interface3);
            interfaces.addAll(list);
            
            checkNumber("Class1 interfaces", class1NumOfInterfaces+2, class1.getInterfaces());
            checkNumber("Interface2 implementors", interface2NumOfImplementors+1, interface2.getImplementors());
            checkNumber("Interface3 implementors", interface3NumOfImplementors+1, interface3.getImplementors());
            
            fail = false;
        }
        finally  {
            Utility.endTrans(fail);
        }
        
        fail = true;
        Utility.beginTrans(true);
        try {
            List interfaces = implementsImpl.getInterfaces(class1);
            List list = new ArrayList();
            list.add(interface2);
            list.add(interface3);
            interfaces.removeAll(list);
            
            checkNumber("Class1 interfaces", class1NumOfInterfaces, class1.getInterfaces());
            checkNumber("Interface2 implementors", interface2NumOfImplementors, interface2.getImplementors());
            checkNumber("Interface3 implementors", interface3NumOfImplementors, interface3.getImplementors());
            
            fail = false;
        }
        finally  {
            Utility.endTrans(fail);
        }

        fail = true;
        Utility.beginTrans(true);
        try {
            List interfaces = implementsImpl.getInterfaces(class1);
            ListIterator it = interfaces.listIterator();
            while (it.hasNext())
                it.next();
            it.add(interface2);
            
            checkNumber("Class1 interfaces", class1NumOfInterfaces+1, class1.getInterfaces());
            checkNumber("Interface2 implementors", interface2NumOfImplementors+1, interface2.getImplementors());
            
            fail = false;
        }
        finally  {
            Utility.endTrans(fail);
        }
        
        fail = true;
        Utility.beginTrans(true);
        try {
            List interfaces = implementsImpl.getInterfaces(class1);
            ListIterator it = interfaces.listIterator();
            while (it.hasNext()) {
                JavaClass _interface = (JavaClass) it.next();
                if (_interface.equals(interface2)) {
                    it.remove();
                    break;
                }
            }
            
            checkNumber("Class1 interfaces", class1NumOfInterfaces, class1.getInterfaces());
            checkNumber("Interface2 implementors", interface2NumOfImplementors, interface2.getImplementors());
            
            fail = false;
        }
        finally  {
            Utility.endTrans(fail);
        }
    }
    
    public void testAddRemoveImplementor() {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            Collection implementors = implementsImpl.getImplementors(interface2); 
            implementors.add(class1);
            
            checkNumber("Class1 interfaces", class1NumOfInterfaces+1, class1.getInterfaces());
            checkNumber("Interface2 implementors", interface2NumOfImplementors+1, interface2.getImplementors());
            
            fail = false;
        }
        finally  {
            Utility.endTrans(fail);
        }
        
        fail = true;
        Utility.beginTrans(true);
        try {
            Collection implementors = implementsImpl.getImplementors(interface2); 
            implementors.remove(class1);
            
            checkNumber("Class1 interfaces", class1NumOfInterfaces, class1.getInterfaces());
            checkNumber("Interface2 implementors", interface2NumOfImplementors, interface2.getImplementors());
            
            fail = false;
        }
        finally  {
            Utility.endTrans(fail);
        }

        fail = true;
        Utility.beginTrans(true);
        try {
            Collection implementors = implementsImpl.getImplementors(interface2);
            List list = new ArrayList();
            list.add(class1); 
            list.add(class3); 
            implementors.addAll(list);
            
            checkNumber("Class1 interfaces", class1NumOfInterfaces+1, class1.getInterfaces());
            checkNumber("Class3 interfaces", class3NumOfInterfaces+1, class3.getInterfaces());
            checkNumber("Interface2 implementors", interface2NumOfImplementors+2, interface2.getImplementors());
            
            fail = false;
        }
        finally  {
            Utility.endTrans(fail);
        }
        
        fail = true;
        Utility.beginTrans(true);
        try {
            Collection implementors = implementsImpl.getImplementors(interface2);
            List list = new ArrayList();
            list.add(class1); 
            list.add(class3); 
            implementors.removeAll(list);
            
            checkNumber("Class1 interfaces", class1NumOfInterfaces, class1.getInterfaces());
            checkNumber("Class3 interfaces", class3NumOfInterfaces, class3.getInterfaces());
            checkNumber("Interface2 implementors", interface2NumOfImplementors, interface2.getImplementors());
            
            fail = false;
        }
        finally  {
            Utility.endTrans(fail);
        }

        fail = true;
        Utility.beginTrans(true);
        try {
            Collection implementors = implementsImpl.getImplementors(interface2); 
            implementors.add(class1);

            checkNumber("Class1 interfaces", class1NumOfInterfaces+1, class1.getInterfaces());
            checkNumber("Interface2 implementors", interface2NumOfImplementors+1, interface2.getImplementors());
            
            fail = false;
        }
        finally  {
            Utility.endTrans(fail);
        }
        
        fail = true;
        Utility.beginTrans(true);
        try {
            Collection implementors = implementsImpl.getImplementors(interface2); 
            Iterator it = implementors.iterator();
            while (it.hasNext()) {
                JavaClass _implementor = (JavaClass) it.next();
                if (_implementor.equals(class1)) {
                    it.remove();
                    break;
                }
            }
            
            checkNumber("Class1 interfaces", class1NumOfInterfaces, class1.getInterfaces());
            checkNumber("Interface2 implementors", interface2NumOfImplementors, interface2.getImplementors());
            
            fail = false;
        }
        finally  {
            Utility.endTrans(fail);
        }
    }
    
}
