/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.jmi.javamodel;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;

import junit.textui.TestRunner;

import org.netbeans.junit.NbTestCase;
import org.netbeans.junit.NbTestSuite;
import org.netbeans.modules.javacore.jmiimpl.javamodel.TransientElement;
import org.netbeans.jmi.javamodel.codegen.Utility;
 

/** 
 * @author Vladimir Hudec
 * 
 * [TODO]: anonymous classes should be also considered
 */
public class TestTest extends NbTestCase {
   
    /** Need to be defined because of JUnit */
    public TestTest(String name) {
        super(name);
        
    } 
    
    public static NbTestSuite suite() {
        NbTestSuite suite = new NbTestSuite();
        suite.addTest(new TestTest("testTest"));
        return suite;
    }
    
    /** Use for execution inside IDE */
    public static void main(java.lang.String[] args) {
        TestRunner.run(suite());
    }

    JavaModelPackage pkg;
    JavaClass class1, class2, class3;
    JavaClass exception1, exception2;
    JavaClass interface1, interface2, interface3;
    
    protected void setUp() {
        pkg = (JavaModelPackage) class1.refImmediatePackage();
        try { Thread.sleep(2000); } catch (Exception ex) {}
        
        class1 = Utility.findClass("org.netbeans.test.classes.Class1");
        assertNotNull("Class1", class1);
        assertFalse("Class1 is instance of UnresolvedClass", class1 instanceof UnresolvedClass);
        class2 = Utility.findClass("org.netbeans.test.classes.Class2");
        assertNotNull("Class2", class2);
        assertFalse("Class2 is instance of UnresolvedClass", class2 instanceof UnresolvedClass);
        class3 = Utility.findClass("org.netbeans.test.classes.Class3");
        assertNotNull("Class3", class3);
        assertFalse("Class3 is instance of UnresolvedClass", class3 instanceof UnresolvedClass);
        
        exception1 = Utility.findClass("org.netbeans.test.exceptions.Exception1");
        assertNotNull("Exception1", exception1);
        assertFalse("Exception1 is instance of UnresolvedClass", exception1 instanceof UnresolvedClass);
        exception2 = Utility.findClass("org.netbeans.test.exceptions.Exception2");
        assertNotNull("Exception2", exception2);
        assertFalse("Exception2 is instance of UnresolvedClass", exception2 instanceof UnresolvedClass);

        interface1 = Utility.findClass("org.netbeans.test.interfaces.Interface1");
        assertNotNull("Interface1", interface1);
        assertFalse("Interface1 is instance of UnresolvedClass", interface1 instanceof UnresolvedClass);
        interface2 = Utility.findClass("org.netbeans.test.interfaces.Interface2");
        assertNotNull("Interface2", interface2);
        assertFalse("Interface2 is instance of UnresolvedClass", interface2 instanceof UnresolvedClass);
        interface3 = Utility.findClass("org.netbeans.test.interfaces.Interface3");
        assertNotNull("Interface3", interface3);
        assertFalse("Interface3 is instance of UnresolvedClass", interface3 instanceof UnresolvedClass);
    }
    
    private class It implements Iterator {
        private final LinkedList iterators = new LinkedList();
        private Iterator currentIterator;
        private Object lastItem = null;
            
        public It(TransientElement te) {
            currentIterator = te.getChildren().iterator();
        }
            
        public It(List list) {
            currentIterator = list.iterator();
        }
            
        public It(StatementBlock sb) {
            currentIterator = sb.getStatements().iterator();
        }
            
        public boolean hasNext() {
            while (lastItem == null && (!iterators.isEmpty() || currentIterator.hasNext())) {
                while (lastItem == null && currentIterator.hasNext()) {
                    Object temp = currentIterator.next();
//                    if (temp instanceof List) {
//                        iterators.add(((List)temp).iterator());
//                        iterators.add(currentIterator);
//                        currentIterator = (Iterator) iterators.remove(0);
//                    }
//                    else if (temp instanceof TransientElement) {
//                        iterators.add(((TransientElement)temp).getChildren().iterator());
//                    }
                    if (temp instanceof List) {
                        iterators.add(0, currentIterator);
                        currentIterator = ((List)temp).iterator();
                    }
                    else if (temp instanceof TransientElement) {
                        iterators.add(0, currentIterator);
                        currentIterator = ((TransientElement)temp).getChildren().iterator();
                    }
                    else if (temp == null) {
                        System.out.println("hasNext(): null element");
                    }
                    else {
                        System.out.println("hasNext(): not transient element");
                    }
                    
                    if (temp instanceof TransientElement) {
                        lastItem = temp;
                    }
                }
                if (lastItem == null) {
                    currentIterator = (Iterator) iterators.remove(0);
                }
            }
            return lastItem != null;
        }
            
        public Object next() {
            //lock();
            try {
                if (hasNext()) {
                    Object result = lastItem;
                    lastItem = null;
                    return result;
                } else {
                    throw new NoSuchElementException();
                }
            } finally {
                //unlock();
            }
        }
            
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

//    variable_initializer: expression
//        | array_initializer -> ArrayInitializationImpl
//
//    expression: assignment_expression
//
//    assignment_expression: conditional_expression -> ConditionImpl
//        | assignment -> AssignmentImpl

    private void printInitialValue(InitialValue iv, String desc) {
        if (iv == null) {
            System.out.println(desc+": initial value is null");
            return;
        }
        
        System.out.println(desc+": "+iv);
        
        if (!(iv instanceof TransientElement)) {
            return;
        }
        
        for (Iterator it = new It((TransientElement) iv); it.hasNext(); ) {
            Object o = it.next();
            System.out.println(".."+o);
        }
    }

//    block_statement: local_variable_declaration_statement
//        | class_declaration
//        | statement
//
//    statement: labeled_statement
//        | if_statement
//        | while_statement
//        | for_statement
//        | block
//        | empty_statement
//        | expression_statement
//        | switch_statement
//        | do_statement
//        | break_statement
//        | continue_statement
//        | return_statement
//        | synchronized_statement
//        | throw_statement
//        | try_statement
//        | assert_statement  


    
    private void printStatementBlock(StatementBlock sb, String desc) {
        if (sb == null) {
            System.out.println(desc+": statement block is null");
            return;
        }
        List statements = sb.getStatements();
        if (statements == null) {
            System.out.println(desc+": statements list is null");
            return;
        }
        
        System.out.println(desc+":");
        for (Iterator it = statements.iterator(); it.hasNext(); ) {
            Object o = it.next();
            System.out.println("  "+o);
        }

        for (Iterator it = new It(sb); it.hasNext(); ) {
            Object o = it.next();
            System.out.println(".."+o);
            if (o instanceof LocalVariable) {
                System.out.println("^^"+((LocalVariable)o).getType());
            }
        }
    }
    
    public void testTest() {
        Utility.beginTrans(false);
        try {
//            Field field1_3 = class1.getField("field1_3", false);
//            InitialValue field1_3_init = field1_3.getInitialValue();
//            printInitialValue(field1_3_init, "field1_3");
            
            List list = new ArrayList();
            Type intType = pkg.getType().resolve("int");
            list.add(intType);
            Type stringType = pkg.getType().resolve("String");
            list.add(stringType);
            Method method1_1 = class1.getMethod("method1_1", list, false);
            StatementBlock method1_1_body = method1_1.getBody();
            printStatementBlock(method1_1_body, "method1_1");
            
            list = new ArrayList();
            list.add(intType);
            list.add(interface1);
            Method method1_2 = class1.getMethod("method1_2", list, false);
            StatementBlock method1_2_body = method1_2.getBody();
            printStatementBlock(method1_2_body, "method1_2");
            
            list = new ArrayList();
            list.add(intType);
            Method method1_3 = class1.getMethod("method1_3", list, false);
            StatementBlock method1_3_body = method1_3.getBody();
            printStatementBlock(method1_3_body, "method1_3");
        }
        finally  {
            Utility.endTrans();
        }
    }
}
