/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.jmi.javamodel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

import javax.jmi.reflect.RefAssociation;
import javax.jmi.reflect.RefAssociationLink;

import junit.textui.TestRunner;

import org.netbeans.junit.NbTestCase;
import org.netbeans.junit.NbTestSuite;
import org.netbeans.modules.javacore.jmiimpl.javamodel.JavaClassImpl;
import org.netbeans.modules.javacore.jmiimpl.javamodel.ResourceImpl;
import org.netbeans.modules.javacore.jmiimpl.javamodel.ThrowsImpl;
import org.netbeans.jmi.javamodel.codegen.Utility;
 

/** 
 * @author Vladimir Hudec
 * 
 * [TODO]: anonymous classes should be also considered
 */
public class ThrowsTest extends NbTestCase {
   
    /** Need to be defined because of JUnit */
    public ThrowsTest(String name) {
        super(name);
        
    } 
    
    public static NbTestSuite suite() {
        NbTestSuite suite = new NbTestSuite();
        suite.addTest(new ThrowsTest("testAllLinks"));
        suite.addTest(new ThrowsTest("testNullArguments"));
        suite.addTest(new ThrowsTest("testImproperArguments"));
        suite.addTest(new ThrowsTest("testAddRemoveAssociation"));
        suite.addTest(new ThrowsTest("testAddRemoveException"));
        suite.addTest(new ThrowsTest("testAddRemoveCallableFeature"));
        return suite;
    }
    
    /** Use for execution inside IDE */
    public static void main(java.lang.String[] args) {
        TestRunner.run(suite());
    }

    JavaModelPackage pkg;
    ThrowsImpl throwsImpl;
    int throwsNumOfCallableFeatures;
    int throwsNumOfExceptions;
    CallableFeature cfeature1, cfeature2, cfeature3;
    JavaClass exception1, exception2;
    int cfeature1NumOfExceptions, cfeature2NumOfExceptions, cfeature3NumOfExceptions;
    int exception1NumOfCFeatures, exception2NumOfCFeatures;
    
    protected void setUp() {
        JavaClass class1 = Utility.findClass("org.netbeans.test.classes.Class1");
        pkg = (JavaModelPackage) class1.refImmediatePackage();
        throwsImpl = (ThrowsImpl) pkg.getThrows();
        try { Thread.sleep(2000); } catch (Exception ex) {}
        assertNotNull("Class1", class1);
        assertFalse("Class1 is instance of UnresolvedClass", class1 instanceof UnresolvedClass);
        JavaClass class2 = Utility.findClass("org.netbeans.test.classes.Class2");
        assertNotNull("Class2", class2);
        assertFalse("Class2 is instance of UnresolvedClass", class2 instanceof UnresolvedClass);
        List list = new ArrayList();
        Type intType = pkg.getType().resolve("int"); list.add(intType);
        Type stringType = pkg.getType().resolve("String"); list.add(stringType);
        cfeature1 = class2.getMethod("method2_1", list, false);
        assertNotNull("class2.method2_1", cfeature1);
        list = new ArrayList(); list.add(intType);
        Type interface2Type = pkg.getType().resolve("org.netbeans.test.interfaces.Interface2"); list.add(interface2Type);
        cfeature2 = class2.getMethod("method2_2", list, false);
        assertNotNull("class2.method2_2", cfeature2);
        list = new ArrayList(); list.add(intType);
        cfeature3 = class1.getMethod("method1_3", list, false);
        assertNotNull("class2.method1_3", cfeature3);

        exception1 = Utility.findClass("org.netbeans.test.exceptions.Exception1");
        assertNotNull("Exception1", exception1);
        assertFalse("Exception1 is instance of UnresolvedClass", exception1 instanceof UnresolvedClass);
        exception2 = Utility.findClass("org.netbeans.test.exceptions.Exception2");
        assertNotNull("Exception2", exception2);
        assertFalse("Exception2 is instance of UnresolvedClass", exception2 instanceof UnresolvedClass);

        // Interface1.method1_1 throws IOException
        // Interface1.method1_2 throws RuntimeException
        // Class1.method1_1 throws IOException
        // Class2.method1_2 throws RuntimeException
        // Interface2.method2_1 throws Exception1
        // Interface2.method2_2 throws Exception2
        // Class2.method2_1 throws Exception1
        // Class2.method2_2 throws Exception2
        throwsNumOfCallableFeatures = 4;
        throwsNumOfExceptions = 4;
        cfeature1NumOfExceptions = 1;
        cfeature2NumOfExceptions = 1;
        cfeature3NumOfExceptions = 0;
        exception1NumOfCFeatures = 2;
        exception2NumOfCFeatures = 2;

        checkNumber("Class2.method2_1 exceptions", cfeature1NumOfExceptions, cfeature1.getExceptions());
        checkNumber("Class2.method2_2 exceptions", cfeature2NumOfExceptions, cfeature2.getExceptions());
        checkNumber("Exception1 callable features", exception1NumOfCFeatures, throwsImpl.getCallableFeatures(exception1));
        checkNumber("Exception2 callable features", exception2NumOfCFeatures, throwsImpl.getCallableFeatures(exception2));
    }
    
    protected void printAllLinks(RefAssociation refAssociation) {
        Collection impls = refAssociation.refAllLinks();
        int numOfLinks = 0;
        for (Iterator it = impls.iterator(); it.hasNext(); ) {
            numOfLinks++;
            RefAssociationLink link = (RefAssociationLink) it.next();
            CallableFeature callableFeature = (CallableFeature) link.refFirstEnd();
            JavaClass exceptionClass = (JavaClass) link.refSecondEnd();
            System.out.println("  #"+numOfLinks+": "+callableFeature.getName()+" throws "+exceptionClass.getName());
        }
    }
    
    protected void checkNumber(String msg, int expectedValue, int actualValue) {
        assertEquals("Total number of "+msg, expectedValue, actualValue);
    }
    
    protected void checkNumber(String msg, int expectedValue, Collection coll) {
        if (expectedValue == 0) {
            assertTrue("Total number of "+msg, coll.isEmpty());
        }
        else {
            checkNumber(msg, expectedValue, coll.size());
        }
    }
    
    public void testAllLinks() {
        Utility.beginTrans(false);
        try {
            Collection thrws = throwsImpl.refAllLinks();
            int numOfLinks = 0;
            int numOfCallableFeatures = 0;
            int numOfExceptions = 0;
            
            String packageOfCallableFeatures = cfeature1.getResource().getPackageName();
            String packageOfExceptions = exception1.getResource().getPackageName();
            
            for (Iterator it = thrws.iterator(); it.hasNext(); ) {
                numOfLinks++;
                RefAssociationLink link = (RefAssociationLink) it.next();
                CallableFeature callableFeature = (CallableFeature) link.refFirstEnd();
                JavaClass exceptionClass = (JavaClass) link.refSecondEnd();
                if (((JavaClass)callableFeature.getDeclaringClass()).getName().startsWith(packageOfCallableFeatures))
                    ++numOfCallableFeatures;
                if (exceptionClass.getName().startsWith(packageOfExceptions))
                    ++numOfExceptions;
                System.out.println("  #"+numOfLinks+": "+callableFeature.getName()+" throws "+exceptionClass.getName());
            }
            
            checkNumber("throwing features", throwsNumOfCallableFeatures, numOfCallableFeatures);
            checkNumber("throwed exceptions", throwsNumOfExceptions, numOfExceptions);
        }
        finally  {
            Utility.endTrans();
        }
    }
    
    public void testNullArguments() {
        String msg = "Association's operation with null argument should throw exception";
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            try {
                throwsImpl.exists(null, exception1);
                fail(msg+" (exists)");
            }
            catch (NullPointerException ex) {
            }
            try {
                throwsImpl.exists(cfeature1, null);
                fail(msg+" (exists)");
            }
            catch (NullPointerException ex) {
            }
            try {
                throwsImpl.add(null, exception1);
                fail(msg+" (add)");
            }
            catch (NullPointerException ex) {
            }
            try {
                throwsImpl.add(cfeature1, null);
                fail(msg+" (add)");
            }
            catch (NullPointerException ex) {
            }
            try {
                throwsImpl.remove(null, exception1);
                fail(msg+" (remove)");
            }
            catch (NullPointerException ex) {
            }
            try {
                throwsImpl.remove(cfeature1, null);
                fail(msg+" (remove)");
            }
            catch (NullPointerException ex) {
            }
            try {
                throwsImpl.getCallableFeatures(exception1).add(null);
                fail(msg+" (getCallableFeatures.add)");
            }
            catch (NullPointerException ex) {
            }
            try {
                throwsImpl.getCallableFeatures(exception1).iterator().remove();
                throwsImpl.getCallableFeatures(exception1).iterator().remove();
                throwsImpl.getCallableFeatures(exception1).iterator().remove();
                fail(msg+" (getCallableFeatures.iterator.remove)");
            }
            catch (IllegalStateException ex) {
            }
            catch (NullPointerException ex) {
                // [TODO] - fix in ReferenceCol/ListWrapper
            }
            
            fail = false;
        }
        finally  {
            Utility.endTrans(fail);
        }
    }
    
    public void testImproperArguments() {
        String msg = "Association's operation with improper argument should throw exception";

        Object obj = new Object();
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            try {
                throwsImpl.getCallableFeatures(exception1).add(obj);
                fail(msg+" (getCallableFeatures.add)");
            }
            catch (javax.jmi.reflect.TypeMismatchException ex) {
            }
            
            fail = false;
        }
        finally  {
            Utility.endTrans(fail);
        }

        fail = true;
        Utility.beginTrans(true);
        try {
            try {
                throwsImpl.getExceptions(cfeature1).add(obj);
                fail(msg+" (getExceptions.add)");
            }
            catch (javax.jmi.reflect.TypeMismatchException ex) {
            }
            
            fail = false;
        }
        finally  {
            Utility.endTrans(fail);
        }

        fail = true;
        Utility.beginTrans(true);
        try {
            try {
                throwsImpl.add(cfeature1, exception1);
                fail(msg+" (Adding existing association)");
            }
            catch (javax.jmi.reflect.WrongSizeException ex) {
            }
            
            fail = false;
        }
        finally  {
            Utility.endTrans(fail);
        }

        fail = true;
        Utility.beginTrans(true);
        try {
            boolean result = throwsImpl.remove(cfeature3, exception1);
            assertFalse("Trying remove nonexisting association", result);
            
            fail = false;
        }
        finally  {
            Utility.endTrans(fail);
        }
    }
    
    public void testAddRemoveAssociation() {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            throwsImpl.add(cfeature3, exception1);
            
            checkNumber("Class1.method1_3 exceptions", cfeature3NumOfExceptions+1, cfeature3.getExceptions());
            checkNumber("Exception1 callable features", exception1NumOfCFeatures+1, throwsImpl.getCallableFeatures(exception1));
            
            fail = false;
        }
        finally  {
            Utility.endTrans(fail);
        }
        
        fail = true;
        Utility.beginTrans(true);
        try {
            throwsImpl.remove(cfeature3, exception1);
            
            checkNumber("Class1.method1_3 exceptions", cfeature3NumOfExceptions, cfeature3.getExceptions());
            checkNumber("Exception1 callable features", exception1NumOfCFeatures, throwsImpl.getCallableFeatures(exception1));
            
            fail = false;
        }
        finally  {
            Utility.endTrans(fail);
        }
    }
    
    public void testAddRemoveException() {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            List exceptions = throwsImpl.getExceptions(cfeature3); 
            exceptions.add(exception1);
            
            checkNumber("Class1.method1_3 exceptions", cfeature3NumOfExceptions+1, cfeature3.getExceptions());
            checkNumber("Exception1 callable features", exception1NumOfCFeatures+1, throwsImpl.getCallableFeatures(exception1));
            
            fail = false;
        }
        finally  {
            Utility.endTrans(fail);
        }
        
        fail = true;
        Utility.beginTrans(true);
        try {
            List exceptions = throwsImpl.getExceptions(cfeature3); 
            exceptions.remove(exception1);
            
            checkNumber("Class1.method1_3 exceptions", cfeature3NumOfExceptions, cfeature3.getExceptions());
            checkNumber("Exception1 callable features", exception1NumOfCFeatures, throwsImpl.getCallableFeatures(exception1));
            
            fail = false;
        }
        finally  {
            Utility.endTrans(fail);
        }

        fail = true;
        Utility.beginTrans(true);
        try {
            List exceptions = throwsImpl.getExceptions(cfeature3); 
            List list = new ArrayList();
            list.add(exception1);
            list.add(exception2);
            exceptions.addAll(list);
            
            checkNumber("Class1.method1_3 exceptions", cfeature3NumOfExceptions+2, cfeature3.getExceptions());
            checkNumber("Exception1 callable features", exception1NumOfCFeatures+1, throwsImpl.getCallableFeatures(exception1));
            checkNumber("Exception2 callable features", exception2NumOfCFeatures+1, throwsImpl.getCallableFeatures(exception2));

            fail = false;
        }
        finally  {
            Utility.endTrans(fail);
        }
        
        fail = true;
        Utility.beginTrans(true);
        try {
            List exceptions = throwsImpl.getExceptions(cfeature3); 
            List list = new ArrayList();
            list.add(exception1);
            list.add(exception2);
            exceptions.removeAll(list);
            
            checkNumber("Class1.method1_3 exceptions", cfeature3NumOfExceptions, cfeature3.getExceptions());
            checkNumber("Exception1 callable features", exception1NumOfCFeatures, throwsImpl.getCallableFeatures(exception1));
            checkNumber("Exception2 callable features", exception2NumOfCFeatures, throwsImpl.getCallableFeatures(exception2));
            
            fail = false;
        }
        finally  {
            Utility.endTrans(fail);
        }

        fail = true;
        Utility.beginTrans(true);
        try {
            List exceptions = throwsImpl.getExceptions(cfeature3); 
            ListIterator it = exceptions.listIterator();
            while (it.hasNext())
                it.next();
            it.add(exception1);
            
            checkNumber("Class1.method1_3 exceptions", cfeature3NumOfExceptions+1, cfeature3.getExceptions());
            checkNumber("Exception1 callable features", exception1NumOfCFeatures+1, throwsImpl.getCallableFeatures(exception1));
            
            fail = false;
        }
        finally  {
            Utility.endTrans(fail);
        }
        
        fail = true;
        Utility.beginTrans(true);
        try {
            List exceptions = throwsImpl.getExceptions(cfeature3); 
            ListIterator it = exceptions.listIterator();
            while (it.hasNext()) {
                JavaClass exception = (JavaClass) it.next();
                if (exception.equals(exception1)) {
                    it.remove();
                    break;
                }
            }
            
            checkNumber("Class1.method1_3 exceptions", cfeature3NumOfExceptions, cfeature3.getExceptions());
            checkNumber("Exception1 callable features", exception1NumOfCFeatures, throwsImpl.getCallableFeatures(exception1));
            
            fail = false;
        }
        finally  {
            Utility.endTrans(fail);
        }
    }
    
    public void testAddRemoveCallableFeature() {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            Collection cfeatures = throwsImpl.getCallableFeatures(exception1); 
            cfeatures.add(cfeature3);
            
            checkNumber("Class1.method1_3 exceptions", cfeature3NumOfExceptions+1, cfeature3.getExceptions());
            checkNumber("Exception1 callable features", exception1NumOfCFeatures+1, throwsImpl.getCallableFeatures(exception1));
            
            fail = false;
        }
        finally  {
            Utility.endTrans(fail);
        }
        
        fail = true;
        Utility.beginTrans(true);
        try {
            Collection cfeatures = throwsImpl.getCallableFeatures(exception1); 
            cfeatures.remove(cfeature3);
            
            checkNumber("Class1.method1_3 exceptions", cfeature3NumOfExceptions, cfeature3.getExceptions());
            checkNumber("Exception1 callable features", exception1NumOfCFeatures, throwsImpl.getCallableFeatures(exception1));
            
            fail = false;
        }
        finally  {
            Utility.endTrans(fail);
        }

        fail = true;
        Utility.beginTrans(true);
        try {
            Collection cfeatures = throwsImpl.getCallableFeatures(exception1);
            List list = new ArrayList();
            list.add(cfeature3); 
            cfeatures.addAll(list);
            
            checkNumber("Class1.method1_3 exceptions", cfeature3NumOfExceptions+1, cfeature3.getExceptions());
            checkNumber("Exception1 callable features", exception1NumOfCFeatures+1, throwsImpl.getCallableFeatures(exception1));
            
            fail = false;
        }
        finally  {
            Utility.endTrans(fail);
        }
        
        fail = true;
        Utility.beginTrans(true);
        try {
            Collection cfeatures = throwsImpl.getCallableFeatures(exception1);
            List list = new ArrayList();
            list.add(cfeature3); 
            cfeatures.removeAll(list);
            
            checkNumber("Class1.method1_3 exceptions", cfeature3NumOfExceptions, cfeature3.getExceptions());
            checkNumber("Exception1 callable features", exception1NumOfCFeatures, throwsImpl.getCallableFeatures(exception1));

            fail = false;
        }
        finally  {
            Utility.endTrans(fail);
        }

        fail = true;
        Utility.beginTrans(true);
        try {
            Collection cfeatures = throwsImpl.getCallableFeatures(exception1); 
            cfeatures.add(cfeature3);
            
            checkNumber("Class1.method1_3 exceptions", cfeature3NumOfExceptions+1, cfeature3.getExceptions());
            checkNumber("Exception1 callable features", exception1NumOfCFeatures+1, throwsImpl.getCallableFeatures(exception1));
            
            fail = false;
        }
        finally  {
            Utility.endTrans(fail);
        }
        
        fail = true;
        Utility.beginTrans(true);
        try {
            Collection cfeatures = throwsImpl.getCallableFeatures(exception1); 
            Iterator it = cfeatures.iterator();
            while (it.hasNext()) {
                CallableFeature cfeature = (CallableFeature) it.next();
                if (cfeature.equals(cfeature3)) {
                    it.remove();
                    break;
                }
            }
            
            checkNumber("Class1.method1_3 exceptions", cfeature3NumOfExceptions, cfeature3.getExceptions());
            checkNumber("Exception1 callable features", exception1NumOfCFeatures, throwsImpl.getCallableFeatures(exception1));
            
            fail = false;
        }
        finally  {
            Utility.endTrans(fail);
        }
    }
    
}
