/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.jmi.javamodel.codegen;

import junit.textui.TestRunner;
import org.netbeans.jmi.javamodel.*;
import org.netbeans.junit.NbTestCase;
import org.netbeans.junit.NbTestSuite;
import java.io.IOException;
import java.lang.reflect.Modifier;

/**
 *
 * @author  Pavel Flaska
 */
public class AnonClassTest extends NbTestCase {
    
    /** Need to be defined because of JUnit */
    public AnonClassTest() {
        super("AnonClassTest");
    }
    
    public static NbTestSuite suite() {
        NbTestSuite suite = new NbTestSuite(AnonClassTest.class);
        return suite;
    }
    
    Method method;
    JavaModelPackage pkg;
    
    protected void setUp() {
        JavaClass clazz = Utility.findClass("org.netbeans.test.codegen.AnonClassTestClass");
        pkg = (JavaModelPackage) clazz.refImmediatePackage();
        method = (Method) clazz.getContents().iterator().next();
    }

    public void testRead() {
        Utility.beginTrans(false);
        try {
            LocalVarDeclaration varDecl = (LocalVarDeclaration) method.getBody().getStatements().get(0);
            LocalVariable var = (LocalVariable) varDecl.getVariables().get(0);
            NewClassExpression nce = (NewClassExpression) var.getInitialValue();
            ClassDefinition cd = nce.getClassDefinition();
            assertEquals("Number of features does not match: ", 3, cd.getFeatures().size());
        } finally {
            Utility.endTrans();
        }
    }

    public void testChange() throws IOException {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            LocalVarDeclaration varDecl = (LocalVarDeclaration) method.getBody().getStatements().get(0);
            LocalVariable var = (LocalVariable) varDecl.getVariables().get(0);
            NewClassExpression nce = (NewClassExpression) var.getInitialValue();
            ClassDefinition cd = nce.getClassDefinition();
            Method compare = (Method) cd.getContents().get(0);
            ((Parameter) compare.getParameters().get(0)).setName("param1");
            ((Parameter) compare.getParameters().get(1)).setName("param2");
            fail = false;
        }
        finally {
            Utility.endTrans(fail);
        }
        assertFile("File is not correctly generated.",
            Utility.getFile(getDataDir(), "org/netbeans/test/codegen/AnonClassTestClass.java"),
            getGoldenFile("AnonClass1.pass"),
            getWorkDir()
        );
    }

    public void testCreate() throws IOException {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            LocalVarDeclaration varDecl = pkg.getLocalVarDeclaration().createLocalVarDeclaration(true, null, null);
            varDecl.setType(pkg.getType().resolve("java.lang.Object"));
            ClassDefinition cd = pkg.getClassDefinition().createClassDefinition();
            NewClassExpression nce = pkg.getNewClassExpression().createNewClassExpression("java.lang.Object", null, null, null, cd);
            LocalVariable var = pkg.getLocalVariable().createLocalVariable("test", null, false, null, 0, nce, null);
            varDecl.getVariables().add(var);
            cd.getContents().add(pkg.getMethod().createMethod("toString", null, Modifier.PUBLIC,  null, null, null, "return null;", null, null, null, pkg.getMultipartId().createMultipartId("String", null, null), 0));
            method.getBody().getStatements().add(0, varDecl);
            fail = false;
        } finally {
            Utility.endTrans(fail);
        }
        assertFile("File is not correctly generated.",
            Utility.getFile(getDataDir(), "org/netbeans/test/codegen/AnonClassTestClass.java"),
            getGoldenFile("AnonClass2.pass"),
            getWorkDir()
        );
    }

    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        TestRunner.run(suite());
    }
    
}
