/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.jmi.javamodel.codegen;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import junit.textui.TestRunner;
import org.netbeans.jmi.javamodel.*;
import org.netbeans.junit.NbTestCase;
import org.netbeans.junit.NbTestSuite;
import org.openide.filesystems.FileStateInvalidException;

/**
 *
 * @author  Pavel Flaska
 */
public class EnumFacilityTest extends NbTestCase {

    JavaClass clazz;
    JavaModelPackage pkg;
    
    /** Creates a new instance of EnumFacilityTest */
    public EnumFacilityTest() {
        super("EnumFacilityTest");
    }

    public static NbTestSuite suite() {
        NbTestSuite suite = new NbTestSuite(EnumFacilityTest.class);
        return suite;
    }

    protected void setUp() {
        clazz = Utility.findClass("org.netbeans.test.codegen.EnumFacilityName");
        pkg = (JavaModelPackage) clazz.refImmediatePackage();
    }
    
    public void testAddConst() throws java.io.IOException, FileStateInvalidException {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            MultipartId par = pkg.getMultipartId().createMultipartId("\"rebirth\"", null, null);
            EnumConstant enumConst = pkg.getEnumConstant().createEnumConstant(
                "NASTASIYA",
                null, // annontations
                0, // modifiers
                null, // javadoc text
                null, // javadoc
                false, // isFinal
                null, // typeName
                0, // dimCount
                par, // initialValue
                null, // initialValueText
                null // body
            );
            ((JavaEnum) clazz.getContents().get(0)).getConstants().add(4, enumConst);
            fail = false;
        }
        finally {
            Utility.endTrans(fail);
        }
        assertFile("File is not correctly generated.",
            Utility.getFile(getDataDir(), "org/netbeans/test/codegen/EnumFacilityName.java"),
            getGoldenFile("testAddConst_EnumFacilityName.pass"),
            getWorkDir()
        );
    }
    
    public void testReorder() throws java.io.IOException, FileStateInvalidException {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            JavaEnum enumeration = (JavaEnum) clazz.getContents().get(0);
            List constants = enumeration.getConstants();
            Object constant = constants.remove(0);
            constants.add(4, constant);
            fail = false;
        } finally {
            Utility.endTrans(fail);
        }
        assertFile("File is not correctly generated.",
            Utility.getFile(getDataDir(), "org/netbeans/test/codegen/EnumFacilityName.java"),
            getGoldenFile("testReorder_EnumFacilityName.pass"),
            getWorkDir()
        );
    }
    
    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        TestRunner.run(suite());
    }
}
