/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.jmi.javamodel.codegen;

import junit.textui.TestRunner;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.junit.NbTestCase;
import org.netbeans.junit.NbTestSuite;
import org.openide.filesystems.FileStateInvalidException;
import java.util.ArrayList;
import java.util.ListIterator;

/**
 *
 * @author  Martin Matula
 */
public class FeaturesListTest extends NbTestCase {
    
    /** Need to be defined because of JUnit */
    public FeaturesListTest() {
        super("FeaturesListTest");
    }
    
    public static NbTestSuite suite() {
        NbTestSuite suite = new NbTestSuite(FeaturesListTest.class);
        return suite;
    }
    
    JavaClass clazz;
    JavaModelPackage pkg;
    
    protected void setUp() {
        clazz = Utility.findClass("org.netbeans.test.codegen.FeatureListTestClass");
        pkg = (JavaModelPackage) clazz.refImmediatePackage();
    }

    public void testRemoveAfterNext() throws java.io.IOException, FileStateInvalidException {
        Utility.beginTrans(true);
        try {
            ArrayList featuresCopy = new ArrayList(clazz.getFeatures());
            ListIterator it1 = featuresCopy.listIterator(2), it2 = clazz.getFeatures().listIterator(2);
            it1.next(); it2.next();
            it1.remove(); it2.remove();
            assertCollection(featuresCopy);
        } finally {
            Utility.endTrans(true);
        }
    }

    public void testRemoveAfterPrevious() throws java.io.IOException, FileStateInvalidException {
        Utility.beginTrans(true);
        try {
            ArrayList featuresCopy = new ArrayList(clazz.getFeatures());
            ListIterator it1 = featuresCopy.listIterator(2), it2 = clazz.getFeatures().listIterator(2);
            it1.previous(); it2.previous();
            it1.remove(); it2.remove();
            assertCollection(featuresCopy);
        } finally {
            Utility.endTrans(true);
        }
    }

    public void testAdd() throws java.io.IOException, FileStateInvalidException {
        Utility.beginTrans(true);
        try {
            ArrayList featuresCopy = new ArrayList(clazz.getFeatures());
            ListIterator it1 = featuresCopy.listIterator(2), it2 = clazz.getFeatures().listIterator(2);
            Method m = pkg.getMethod().createMethod();
            it1.add(m); it2.add(m);
            assertCollection(featuresCopy);
        } finally {
            Utility.endTrans(true);
        }
    }

    public void testSetAfterNext() throws java.io.IOException, FileStateInvalidException {
        Utility.beginTrans(true);
        try {
            ArrayList featuresCopy = new ArrayList(clazz.getFeatures());
            ListIterator it1 = featuresCopy.listIterator(2), it2 = clazz.getFeatures().listIterator(2);
            it1.next(); it2.next();
            Method m = pkg.getMethod().createMethod();
            it1.set(m); it2.set(m);
            assertCollection(featuresCopy);
        } finally {
            Utility.endTrans(true);
        }
    }

    public void testSetAfterPrevious() throws java.io.IOException, FileStateInvalidException {
        Utility.beginTrans(true);
        try {
            ArrayList featuresCopy = new ArrayList(clazz.getFeatures());
            ListIterator it1 = featuresCopy.listIterator(2), it2 = clazz.getFeatures().listIterator(2);
            it1.previous(); it2.previous();
            Method m = pkg.getMethod().createMethod();
            it1.set(m); it2.set(m);
            assertCollection(featuresCopy);
        } finally {
            Utility.endTrans(true);
        }
    }

    private void assertCollection(ArrayList featuresCopy) {
        assertEquals("Incorrect collection state", featuresCopy, clazz.getFeatures());
    }


    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        TestRunner.run(suite());
    }
    
}
