/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.jmi.javamodel.codegen;

import java.lang.reflect.Modifier;
import java.util.Iterator;
import junit.textui.TestRunner;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.FieldGroup;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.TypeReference;
import org.netbeans.junit.NbTestCase;
import org.netbeans.junit.NbTestSuite;
import org.netbeans.modules.javacore.jmiimpl.javamodel.TypeReferenceImpl;
import org.openide.filesystems.FileStateInvalidException;

/**
 *
 * @author  Pavel Flaska
 */
public class FieldTest2 extends NbTestCase {
    
    /** Creates a new instance of FieldTest2 */
    public FieldTest2() {
        super("FieldTest2");
    }
    
    public static NbTestSuite suite() {
        NbTestSuite suite = new NbTestSuite(FieldTest2.class);
        return suite;
    }
    
    JavaClass clazz;
    JavaModelPackage pkg;
    
    protected void setUp() {
        clazz = Utility.findClass("org.netbeans.test.codegen.FieldTest2");
        pkg = (JavaModelPackage) clazz.refImmediatePackage();
    }

    /**
     * Test move field from field group to the single field declaration.
     */
    public void testMoveField() throws java.io.IOException, FileStateInvalidException {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            Field nerudova = null;
            for (Iterator fIt = clazz.getContents().iterator(); fIt.hasNext(); ) {
                Object feature = fIt.next();
                if (feature instanceof FieldGroup) {
                    FieldGroup group = (FieldGroup) feature;
                    nerudova = (Field) group.getFields().remove(2);
                    nerudova.setTypeName((TypeReference) ((TypeReferenceImpl) group.getTypeName()).duplicate());
                    nerudova.setModifiers(Modifier.PRIVATE);
                }
            }
            clazz.getFeatures().add(nerudova);
            fail = false;
        }
        finally {
            Utility.endTrans(fail);
        }
        assertFile("File is not correctly generated.",
            Utility.getFile(getDataDir(), "org/netbeans/test/codegen/FieldTest2.java"),
            getGoldenFile("FieldTest2.pass"),
            getWorkDir()
        );
    }
    
    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        TestRunner.run(suite());
    }
    
}
