/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.jmi.javamodel.codegen;

import java.util.Collections;
import junit.textui.TestRunner;
import org.netbeans.jmi.javamodel.Expression;
import org.netbeans.jmi.javamodel.ForEachStatement;

import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.junit.NbTestCase;
import org.netbeans.junit.NbTestSuite;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.MethodInvocation;
import org.netbeans.jmi.javamodel.MultipartId;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.Statement;
import org.netbeans.jmi.javamodel.StatementBlock;
import org.netbeans.jmi.javamodel.TypeReference;
import org.openide.filesystems.AbstractFileSystem.List;
import org.openide.filesystems.FileStateInvalidException;

/**
 *
 * @author  Pavel Flaska
 */
public class ForEachTest1 extends NbTestCase {

    /** Creates a new instance of ForEachTest1 */
    public ForEachTest1() {
        super("ForEachTest1");
    }

    public static NbTestSuite suite() {
        NbTestSuite suite = new NbTestSuite(ForEachTest1.class);
        return suite;
    }
    
    Method method;
    JavaModelPackage pkg;
    
    protected void setUp() {
        JavaClass clazz = Utility.findClass("org.netbeans.test.codegen.ForEachTest1");
        pkg = (JavaModelPackage) clazz.refImmediatePackage();
        method = (Method) clazz.getContents().iterator().next();
    }

    public void testForCreation() throws java.io.IOException, FileStateInvalidException {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            // parameter
            TypeReference typeRef = pkg.getMultipartId().createMultipartId("String", null, null);
            Parameter parameter = pkg.getParameter().createParameter("s", null, false, typeRef, 0, false);
            // iterable
            Expression iterable = pkg.getMultipartId().createMultipartId("c", null, null);
            // method invocation
            Expression par = pkg.getMultipartId().createMultipartId("s", null, null);
            MultipartId parent = pkg.getMultipartId().createMultipartId("System.out", null, null);
            MethodInvocation invocation = pkg.getMethodInvocation().createMethodInvocation("println", Collections.singletonList(par), parent, false);
            Statement statement = pkg.getExpressionStatement().createExpressionStatement(invocation);
            // for body
            StatementBlock forBody = pkg.getStatementBlock().createStatementBlock();
            forBody.getStatements().add(statement);
            // for (String s : c) {
            //     System.out.println(s);
            // }
            ForEachStatement fes = pkg.getForEachStatement().createForEachStatement(forBody, parameter, iterable);
            // add to method
            method.getBody().getStatements().add(fes);
            fail = false;
        } finally {
            Utility.endTrans(fail);
        }
        assertFile("File is not correctly generated.",
            Utility.getFile(getDataDir(), "org/netbeans/test/codegen/ForEachTest1.java"),
            getGoldenFile("testForCreation_ForEachTest1.pass"),
            getWorkDir()
        );
    }
    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        TestRunner.run(suite());
    }
}
