/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.jmi.javamodel.codegen;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import junit.textui.TestRunner;
import org.netbeans.jmi.javamodel.Expression;
import org.netbeans.jmi.javamodel.ForStatement;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.LocalVarDeclaration;
import org.netbeans.jmi.javamodel.LocalVariable;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.MethodClass;
import org.netbeans.jmi.javamodel.MultipartId;
import org.netbeans.jmi.javamodel.OperatorEnum;
import org.netbeans.jmi.javamodel.Statement;
import org.netbeans.jmi.javamodel.StatementBlock;
import org.netbeans.jmi.javamodel.UnaryExpression;
import org.netbeans.junit.NbTestCase;
import org.netbeans.junit.NbTestSuite;
import org.openide.filesystems.FileStateInvalidException;

/**
 *
 * @author  Pavel Flaska
 */
public class FormatterTest extends NbTestCase {
    
    /** Need to be defined because of JUnit */
    public FormatterTest() {
        super("FormatterTest");
    }
    
    public static NbTestSuite suite() {
        NbTestSuite suite = new NbTestSuite(FormatterTest.class);
        return suite;
    }
    
    JavaClass clazz;
    JavaModelPackage pkg;
    MethodClass methodProxy;
    
    protected void setUp() {
        clazz = Utility.findClass("org.netbeans.test.codegen.FormattedClass");
        pkg = (JavaModelPackage) clazz.refImmediatePackage();
        methodProxy = pkg.getMethod();
    }

    private Statement createIfStatem() {
        StatementBlock then1 = pkg.getStatementBlock().createStatementBlock(Collections.singletonList(pkg.getEmptyStatement().createEmptyStatement()));
        StatementBlock else1 = pkg.getStatementBlock().createStatementBlock(Collections.singletonList(pkg.getEmptyStatement().createEmptyStatement()));
        UnaryExpression left = pkg.getIntLiteral().createIntLiteral(12);
        UnaryExpression right = pkg.getIntLiteral().createIntLiteral(5);
        Expression cond = pkg.getInfixExpression().createInfixExpression(left, OperatorEnum.NEQUAL, right);
        return pkg.getIfStatement().createIfStatement(cond, then1, else1);
    }
    
    public void testForStatement() throws java.io.IOException, FileStateInvalidException {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            MultipartId id = pkg.getMultipartId().createMultipartId("int", null, null);
            MultipartId id2 = pkg.getMultipartId().createMultipartId("int", null, null);
            MultipartId id3 = pkg.getMultipartId().createMultipartId("int", null, null);
            LocalVariable lv = pkg.getLocalVariable().createLocalVariable(
                "i", // name
                null, // annotations
                false, // isFinal
                id, // typeName
                0, // dimCount
                null,
                "0"
            );
            List varList = new ArrayList(1);
            varList.add(lv);
            LocalVarDeclaration lvd = pkg.getLocalVarDeclaration().createLocalVarDeclaration(false, id2, varList);
            List initList = new ArrayList(1);
            initList.add(lvd);
            List steps = new ArrayList(1);
            // i == 0
            UnaryExpression left = pkg.getMultipartId().createMultipartId("i", null, null);
            UnaryExpression stepVar = pkg.getMultipartId().createMultipartId("i", null, null);
            Expression right = pkg.getIntLiteral().createIntLiteral(5);
            Expression cond = pkg.getInfixExpression().createInfixExpression(left, OperatorEnum.LTE, right);
            steps.add(pkg.getPostfixExpression().createPostfixExpression(OperatorEnum.INC, stepVar));
            ForStatement forStmt = pkg.getForStatement().createForStatement(cond, steps, pkg.getEmptyStatement().createEmptyStatement(), initList);
            List statem = new ArrayList();
            statem.add(forStmt);
            statem.add(createIfStatem());
            StatementBlock block = pkg.getStatementBlock().createStatementBlock(statem);
            Method forova = methodProxy.createMethod(
                "forovaMethod", // name
                null, // annotations
                Modifier.PUBLIC, // modifiers
                "no javadoc", //javaDocText
                null, // javaDoc
                block, // body
                null, // bodyText
                null, // typeArguments
                null, // parameters
                null, // exceptions names
                id3, // typeName
                0 // dims
            );
            clazz.getFeatures().add(forova);
            fail = false;
        }
        finally {
            Utility.endTrans(fail);
        }
        assertFile("File is not correctly generated.",
            Utility.getFile(getDataDir(), "org/netbeans/test/codegen/FormattedClass.java"),
            getGoldenFile("FormattedClass.pass"),
            getWorkDir()
        );
    }

    
    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        TestRunner.run(suite());
    }
    
}
