/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.jmi.javamodel.codegen;

import org.netbeans.junit.NbTestSuite;
import org.netbeans.junit.NbTestCase;
import org.netbeans.jmi.javamodel.*;
import org.openide.filesystems.FileStateInvalidException;
import junit.textui.TestRunner;
import java.io.IOException;
import java.util.Arrays;

/**
 * @author Martin Matula
 */
public class GenericsTest extends NbTestCase {
    public GenericsTest() {
        super("GenericsTest");
    }

    public static NbTestSuite suite() {
        NbTestSuite suite = new NbTestSuite(GenericsTest.class);
        return suite;
    }

    JavaClass clazz;
    JavaModelPackage pkg;

    protected void setUp() {
        clazz = (JavaClass) Utility.findClass("org.netbeans.test.codegen.Generics");
        pkg = (JavaModelPackage) clazz.refImmediatePackage();
    }

    public void testAddBound() throws java.io.IOException, FileStateInvalidException {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            TypeParameter tp = (TypeParameter) clazz.getTypeParameters().get(0);
            tp.getInterfaceNames().add(pkg.getMultipartId().createMultipartId("List", null, null));
            fail = false;
        }
        finally {
            Utility.endTrans(fail);
        }
        assertFile("File is not correctly generated.",
                getGoldenFile("Generics.pass"),
                Utility.getFile(getDataDir(), "org/netbeans/test/codegen/Generics.java"),
                getWorkDir()
        );
    }

    public void testAddTypeParamMethod() throws IOException, FileStateInvalidException {
        JavaClass cls = (JavaClass) Utility.findClass("org.netbeans.test.codegen.GenericMethod");
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            TypeParameter tp = pkg.getTypeParameter().createTypeParameter("Y", null, 0, null, null, null, null, Arrays.asList(new Object[] {pkg.getMultipartId().createMultipartId("Collection", null, null)}), null);
            Method m = (Method) cls.getContents().get(0);
            m.getTypeParameters().add(tp);
            fail = false;
        }
        finally {
            Utility.endTrans(fail);
        }
        assertFile("File is not correctly generated.",
                getGoldenFile("GenericMethod.pass"),
                Utility.getFile(getDataDir(), "org/netbeans/test/codegen/GenericMethod.java"),
                getWorkDir()
        );
    }

    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        TestRunner.run(suite());
    }

}
