/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
/*
 * GroupTest2.java
 *
 * Created on March 1, 2004, 2:30 PM
 */

package org.netbeans.jmi.javamodel.codegen;

import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.FieldGroup;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.MultipartId;
import org.netbeans.junit.NbTestCase;
import org.netbeans.junit.NbTestSuite;
import org.openide.filesystems.FileStateInvalidException;

/**
 *
 * @author  Pavel Flaska
 */
public class GroupTest2 extends NbTestCase {
    
    /** Creates a new instance of GroupTest2 */
    public GroupTest2() {
        super("GroupTest2");
    }
    
    public static NbTestSuite suite() {
        NbTestSuite suite = new NbTestSuite(GroupTest2.class);
        return suite;
    }
    
    JavaClass clazz;
    JavaModelPackage pkg;
    
    protected void setUp() {
        clazz = Utility.findClass("org.netbeans.test.codegen.GroupTest2Class");
        pkg = (JavaModelPackage) clazz.refImmediatePackage();
    }
    
    /**
     * Creates new group with four fields.
     * public String chicco, lego, fisherPrice = "nice", disney;
     */
    public void testGroupCreation() throws IOException, FileStateInvalidException {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            List fields = new ArrayList(4);
            String[] fieldNames = { "chicco", "lego", "fisherPrice", "disney" };
            String[] fieldInitials = { null, null, "\"nice\"", null };
            for (int i = 0; i < 4; i++) {
                MultipartId id = pkg.getMultipartId().createMultipartId("String", null, null);
                fields.add(pkg.getField().createField(
                    fieldNames[i],
                    null,
                    Modifier.PUBLIC,
                    null,
                    null,
                    false,
                    id,
                    0, 
                    null, 
                    fieldInitials[i]
                ));
            };
            MultipartId id = pkg.getMultipartId().createMultipartId("String", null, null);
            clazz.getContents().add(pkg.getFieldGroup().createFieldGroup(
                null,
                null,
                Modifier.PUBLIC, 
                null,
                null,
                id, 
                fields
            ));
            fail = false;
        }
        finally {
            Utility.endTrans(fail);
        }
        assertFile("File is not correctly generated.",
            Utility.getFile(getDataDir(), "org/netbeans/test/codegen/GroupTest2Class.java"),
            getGoldenFile("testGroupCreation_GroupTest2Class.pass"),
            getWorkDir()
        );
    }
    
    /**
     * Change the modifier of the third field and this should cause group
     * split.
     */
    public void testGroupSplit1()  throws IOException, FileStateInvalidException {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            FieldGroup group = (FieldGroup) clazz.getContents().get(1);
            ((Field) group.getFields().get(2)).setModifiers(Modifier.PRIVATE);
            fail = false;
        }
        finally {
            Utility.endTrans(fail);
        }
        assertFile("File is not correctly generated.",
            Utility.getFile(getDataDir(), "org/netbeans/test/codegen/GroupTest2Class.java"),
            getGoldenFile("testGroupSplit1_GroupTest2Class.pass"),
            getWorkDir()
        );
    }
    
    /**
     * Change the type of the first and the last 
     */
    public void testGroupSplit2()  throws IOException, FileStateInvalidException {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            MultipartId id = pkg.getMultipartId().createMultipartId("long", null, null);
            FieldGroup group = (FieldGroup) clazz.getContents().get(0);
            ((Field) group.getFields().get(2)).setTypeName(id);
            fail = false;
        }
        finally {
            Utility.endTrans(fail);
        }
        assertFile("File is not correctly generated.",
            Utility.getFile(getDataDir(), "org/netbeans/test/codegen/GroupTest2Class.java"),
            getGoldenFile("testGroupSplit2_GroupTest2Class.pass"),
            getWorkDir()
        );
    }
    
    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
    }
    
}
