/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.jmi.javamodel.codegen;

import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.List;
import java.io.IOException;
import org.openide.filesystems.FileStateInvalidException;
import junit.textui.TestRunner;
import org.netbeans.jmi.javamodel.*;
import org.netbeans.junit.NbTestCase;
import org.netbeans.junit.NbTestSuite;

/**
 *
 * @author  Pavel Flaska
 */
public class MethodTypeTest extends NbTestCase {
    
    public MethodTypeTest() {
        super("MethodTypeTest");
    }
    
    public static NbTestSuite suite() {
        NbTestSuite suite = new NbTestSuite(MethodTypeTest.class);
        return suite;
    }
    
    private JavaModelPackage pkg;
    private JavaClass clazz;
    
    protected void setUp() {
        clazz = Utility.findClass("org.netbeans.test.codegen.MethodTypeClass");
        pkg = (JavaModelPackage) clazz.refImmediatePackage();
    }

    public void testGetTypeConstr() {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            Constructor constr = (Constructor) clazz.getContents().get(1);
            ExpressionStatement stat = (ExpressionStatement) constr.getBody().getStatements().get(0);
            Assignment assign = (Assignment) stat.getExpression();
            MethodInvocation invo = (MethodInvocation) assign.getRightSide();
            if ("org.netbeans.test.codegen.Retezec".equals(invo.getType().getName()) == false) {
                fail("Expected return type Retezec not found. (Found " + invo.getType().getName() + ").");
            }
            fail = false;
        } finally {
            Utility.endTrans(fail);
        }
    }
    
    public void testGetMethodType() {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            Method method = (Method) clazz.getContents().get(2);
            Type type = method.getType();
            if ("org.netbeans.test.codegen.Retezec".equals(type.getName()) == false) {
                fail("Expected return type Retezec not found. (Found " + type.getName() + ").");
            }
            fail = false;
        } finally {
            Utility.endTrans(fail);
        }
    }
    
    public void testGetTypeInvocation() {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            Method method = (Method) clazz.getContents().get(2);
            ReturnStatement stat = (ReturnStatement) method.getBody().getStatements().get(0);
            MethodInvocation invo = (MethodInvocation) stat.getExpression();
            if ("org.netbeans.test.codegen.Retezec".equals(invo.getType().getName()) == false) {
                fail("Expected return type Retezec not found. (Found " + invo.getType().getName() + ").");
            }
            fail = false;
        } finally {
            Utility.endTrans(fail);
        }
    }
    
    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        TestRunner.run(suite());
    }
}
