/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.jmi.javamodel.codegen;

import java.io.IOException;
import java.lang.reflect.Modifier;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.ExpressionStatement;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.NewClassExpression;
import org.netbeans.jmi.javamodel.PrimitiveTypeKindEnum;
import org.netbeans.junit.NbTestCase;
import org.netbeans.junit.NbTestSuite;
import org.openide.filesystems.FileStateInvalidException;

/**
 *
 * @author Pavel Flaska
 */
public class NewClassWithAnnTest extends NbTestCase {
    
    /** Creates a new instance of NewClassWithAnnTest */
    public NewClassWithAnnTest() {
        super("NewClassWithAnnTest");
    }
    
    public static NbTestSuite suite() {
        NbTestSuite suite = new NbTestSuite(NewClassWithAnnTest.class);
        return suite;
    }
    
    JavaClass clazz;
    JavaModelPackage pkg;
    
    protected void setUp() {
        clazz = Utility.findClass("org.netbeans.test.codegen.NewClassWithAnn");
        pkg = (JavaModelPackage) clazz.refImmediatePackage();
    }
    
    public void testAddBody() throws IOException, FileStateInvalidException {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            Method m = (Method) clazz.getContents().get(0);
            ExpressionStatement st = (ExpressionStatement) m.getBody().getStatements().get(0);
            NewClassExpression nce = (NewClassExpression) st.getExpression();
            ClassDefinition cd = pkg.getClassDefinition().createClassDefinition();
            cd.setSuperClassName(pkg.getMultipartId().createMultipartId("java.lang.Runnable", null, null));
            Method m1 = pkg.getMethod().createMethod("run", null, Modifier.PUBLIC, null, null,
                    null, null, null, null, null, pkg.getMultipartId().createMultipartId("void", null, null), 0);
            cd.getContents().add(m1);
            nce.setClassDefinition(cd);
            fail = false;
        }
        finally {
            Utility.endTrans(fail);
        }
        assertFile("File is not correctly generated.",
            Utility.getFile(getDataDir(), "org/netbeans/test/codegen/NewClassWithAnn.java"),
            getGoldenFile("testAddBody_NewClassWithAnn.pass"),
            getWorkDir()
        );
    }
}
