/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.jmi.javamodel.codegen;

import java.util.List;
import junit.textui.TestRunner;
import org.netbeans.jmi.javamodel.Constructor;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.MultipartId;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.junit.NbTestCase;
import org.netbeans.junit.NbTestSuite;
import org.openide.filesystems.FileStateInvalidException;

/**
 *
 * @author Pavel Flaska
 */
public class ParDimCountTest extends NbTestCase {
    
    JavaClass clazz;
    JavaModelPackage pkg;
    List/*<Parameters>*/ parameters;
    
    /** Creates a new instance of ParDimCountTest */
    public ParDimCountTest() {
        super("ParDimCountTest");
    }
    
    public static NbTestSuite suite() {
        NbTestSuite suite = new NbTestSuite(ParDimCountTest.class);
        return suite;
    }
    
    protected void setUp() {
        clazz = (JavaClass) Utility.findClass("org.netbeans.test.codegen.ParDimCount");
        pkg = (JavaModelPackage) clazz.refImmediatePackage();
        parameters = ((Constructor) clazz.getContents().get(0)).getParameters();
    }
    
    public void testParDim1To2() throws java.io.IOException, FileStateInvalidException {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            ((Parameter) parameters.get(0)).setDimCount(2);
            fail = false;
        }
        finally {
            Utility.endTrans(fail);
        }
        assertFile("File is not correctly generated.",
            Utility.getFile(getDataDir(), "org/netbeans/test/codegen/ParDimCount.java"),
            getGoldenFile("testParDim1To2_ParDimCountTest.pass"),
            getWorkDir()
        );
    }
    
    public void testParDim1To0() throws java.io.IOException, FileStateInvalidException {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            ((Parameter) parameters.get(1)).setDimCount(0);
            fail = false;
        }
        finally {
            Utility.endTrans(fail);
        }
        assertFile("File is not correctly generated.",
            Utility.getFile(getDataDir(), "org/netbeans/test/codegen/ParDimCount.java"),
            getGoldenFile("testParDim1To0_ParDimCountTest.pass"),
            getWorkDir()
        );
    }
    
    public void testCreateDimPar() throws java.io.IOException, FileStateInvalidException {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            MultipartId id = pkg.getMultipartId().createMultipartId("java.util.List", null, null);
            parameters.add(pkg.getParameter().createParameter("l", null, false, id, 2, false));
            fail = false;
        }
        finally {
            Utility.endTrans(fail);
        }
        assertFile("File is not correctly generated.",
            Utility.getFile(getDataDir(), "org/netbeans/test/codegen/ParDimCount.java"),
            getGoldenFile("testCreateDimPar_ParDimCountTest.pass"),
            getWorkDir()
        );
    }
    
    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        TestRunner.run(suite());
    }

}
