/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.jmi.javamodel.codegen;

import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.List;
import java.io.IOException;
import org.openide.filesystems.FileStateInvalidException;
import junit.textui.TestRunner;
import org.netbeans.junit.NbTestCase;
import org.netbeans.junit.NbTestSuite;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.jmi.javamodel.Import;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.MultipartId;
import org.netbeans.jmi.javamodel.TypeReference;

/**
 *
 * @author  Pavel Flaska
 */
public class ParametersTest extends NbTestCase {
    
    /** Creates a new instance of ParametersTest */
    public ParametersTest() {
        super("ParametersTest");
    }
    
    public static NbTestSuite suite() {
        NbTestSuite suite = new NbTestSuite(ParametersTest.class);
        return suite;
    }
    
    private JavaModelPackage pkg;
    private JavaClass clazz;
    
    protected void setUp() {
        clazz = Utility.findClass("org.netbeans.test.codegen.ParametersTestClass");
        pkg = (JavaModelPackage) clazz.refImmediatePackage();
    }

    /**
     * Tests creation of method with varArg parameter.
     */
    public void testCreation() throws IOException, FileStateInvalidException {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            // private boolean tretiMethod(String... varString) {
            //     return true;
            // }
            MultipartId typeName = pkg.getMultipartId().createMultipartId("boolean", null, null);
            MultipartId parType = pkg.getMultipartId().createMultipartId("long", null, null);
            Parameter par = pkg.getParameter().createParameter(
                "varString",      // name
                null,             // annotations
                false,            // is final?
                parType,          // parameter's type
                0,                // dimCount
                true              // is variable arguments?
            );
            Method newMethod = pkg.getMethod().createMethod(
                "tretiMethod",                   // method name
                null,                            // annotations
                Modifier.PRIVATE,                // modifiers
                null,                            // javadocText
                null,                            // javadoc
                null,                            // body
                "return true;",                  // bodyText
                null, 
                Collections.singletonList(par),  // parameters
                Collections.EMPTY_LIST,          // exception names
                typeName,                        // return type
                0                                // dimCount
            );
            Type type = pkg.getType().resolve("String");
            par.setType(type);
            clazz.getFeatures().add(newMethod);
            fail = false;
        } finally {
            Utility.endTrans(fail);
        }
        assertFile("File is not correctly generated.",
            Utility.getFile(getDataDir(), "org/netbeans/test/codegen/ParametersTestClass.java"),
            getGoldenFile("testCreation_ParametersTest.pass"),
            getWorkDir()
        );
    }
    
    public void testSwapTypeChng() throws IOException, FileStateInvalidException {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            Method method = (Method) clazz.getContents().get(2);
            List pars = method.getParameters();
            Parameter par0 = (Parameter) pars.remove(0);
            Type type = pkg.getType().resolve("long");
            MultipartId typeName = pkg.getMultipartId().createMultipartId("short", null, null);
            par0.setType(type);
            par0.setTypeName(typeName);
            pars.add(par0);
            fail = false;
        } finally {
            Utility.endTrans(fail);
        }
        assertFile("File is not correctly generated.",
            Utility.getFile(getDataDir(), "org/netbeans/test/codegen/ParametersTestClass.java"),
            getGoldenFile("testSwapTypeChng_ParametersTest.pass"),
            getWorkDir()
        );
    }
    
    public void testAddChng() throws IOException, FileStateInvalidException {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            Method method = (Method) clazz.getContents().get(1);
            List pars = method.getParameters();
            MultipartId typeName = pkg.getMultipartId().createMultipartId("boolean", null, null);
            MultipartId parType = pkg.getMultipartId().createMultipartId("long", null, null);
            Parameter par = (Parameter) pkg.getParameter().createParameter(
                "novyParameter",  // name
                null,             // annotations
                true,             // is final?
                parType,          // parameter's type
                1,                // dimCount
                false             // is variable arguments?
            );
            Type type = pkg.getType().resolve("long[][]");
            par.setTypeName(typeName);
            par.setType(type);
            pars.add(par);
            fail = false;
        } finally {
            Utility.endTrans(fail);
        }
        assertFile("File is not correctly generated.",
            Utility.getFile(getDataDir(), "org/netbeans/test/codegen/ParametersTestClass.java"),
            getGoldenFile("testAddChng_ParametersTest.pass"),
            getWorkDir()
        );
    }
    
    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        TestRunner.run(suite());
    }
}
