/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.jmi.javamodel.codegen.Positions;

import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.List;
import org.netbeans.jmi.javamodel.*;
import org.netbeans.junit.NbTestSuite;
import junit.textui.TestRunner;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.jmi.javamodel.codegen.CodegenTestCase;
import org.netbeans.jmi.javamodel.codegen.Utility;

/**
 * Tests the method generator.
 *
 * @author  Pavel Flaska
 */
public class ClassPositionsTest extends CodegenTestCase {
    
    /** Need to be defined because of JUnit */
    public ClassPositionsTest(String name) {
        super(name, "ClassPositionsTest");
    }
    
    public static NbTestSuite suite() {
        NbTestSuite suite = new NbTestSuite(ClassPositionsTest.class);
        return suite;
    }
    
    JavaClass clazz;
    JavaModelPackage pkg;
    String sourceText;
    
    protected void setUp() {
        clazz = Utility.findClass("org.netbeans.test.codegen.ClassPositionTest");
        pkg = (JavaModelPackage) clazz.refImmediatePackage();
        sourceText = clazz.getResource().getSourceText();
    }

    public void testName() {
        Utility.beginTrans(false);
        try {
            int nameSO = clazz.getPartStartOffset(ElementPartKindEnum.NAME);
            int nameEO = clazz.getPartEndOffset(ElementPartKindEnum.NAME);
            assertEquals("Class name does not match.", "ClassPositionTest", sourceText.substring(nameSO, nameEO));
        }
        finally  {
            Utility.endTrans();
        }
    }

    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        TestRunner.run(suite());
    }
}
